/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.logout;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.request.HttpContext;
import juzu.request.SecurityContext;
import org.apache.http.message.BasicNameValuePair;
import org.exoplatform.brandadvocacy.model.Address;
import org.exoplatform.brandadvocacy.model.Mission;
import org.exoplatform.brandadvocacy.model.MissionParticipant;
import org.exoplatform.brandadvocacy.model.Participant;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.model.Proposition;
import org.exoplatform.brandadvocacy.model.Size;
import org.exoplatform.brandadvocacy.model.Status;
import org.exoplatform.brandadvocacy.service.ApacheHttpClient;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.brandadvocacy.service.Utils;
import org.exoplatform.community.brandadvocacy.portlet.logout.templates.index;
import org.exoplatform.community.brandadvocacy.portlet.logout.templates.process;
import org.exoplatform.community.brandadvocacy.portlet.logout.templates.stepContainer;
import org.exoplatform.community.brandadvocacy.portlet.logout.templates.terminate;
import org.exoplatform.community.brandadvocacy.portlet.logout.templates.thankyou;
import org.json.JSONObject;

@SessionScoped
public class JuZLogoutApplication {
    @Inject
    IService jcrService;
    String remoteUserName;
    String currentMissionParticipantId;
    String currentMissionParticipantStatus;
    String currentPropositionId;
    String currentMissionId;
    String currentProgramId;
    String currentProgramTitle;
    Boolean isFinished;
    String bannerUrl;
    String sizeOutOfStock;
    String save_user_data_endpoint;
    String save_user_data_endpoint_token;
    String save_user_data_request_method;
    List mktoAttributes;
    String email_player;
    String firstname_player;
    String lastname_player;
    JSONObject currentSettings;
    @Inject
    @Path(value="index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="stepContainer.gtmpl")
    stepContainer stepContainerTpl;
    @Inject
    @Path(value="process.gtmpl")
    process processTpl;
    @Inject
    @Path(value="terminate.gtmpl")
    terminate terminateTpl;
    @Inject
    @Path(value="thankyou.gtmpl")
    thankyou thankyouTpl;

    private void init() {
        this.mktoAttributes = new ArrayList();
        this.email_player = "";
        this.firstname_player = "";
        this.lastname_player = "";
        this.currentMissionId = null;
        this.currentMissionParticipantId = null;
        this.currentPropositionId = null;
        this.currentMissionParticipantStatus = null;
        if (null == this.currentProgramId) {
            this.loadCurrentProgram();
        }
        if (null != this.currentProgramId) {
            this.getRandomMission();
        }
    }

    private void initUTMCookie(HttpContext httpContext) {
        String defaultVal;
        Cookie[] cookies = httpContext.getCookies();
        String utm_content = defaultVal = "no-params";
        String utm_term = defaultVal;
        String utm_campaign = defaultVal;
        String utm_medium = defaultVal;
        String utm_source = defaultVal;
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if ("utm_content".equals(cookieName)) {
                utm_content = cookie.getValue();
                continue;
            }
            if ("utm_term".equals(cookieName)) {
                utm_term = cookie.getValue();
                continue;
            }
            if ("utm_campaign".equals(cookieName)) {
                utm_campaign = cookie.getValue();
                continue;
            }
            if ("utm_medium".equals(cookieName)) {
                utm_medium = cookie.getValue();
                continue;
            }
            if (!"utm_source".equals(cookieName)) continue;
            utm_source = cookie.getValue();
        }
        this.mktoAttributes.add(new BasicNameValuePair("utm_content", utm_content));
        this.mktoAttributes.add(new BasicNameValuePair("utm_term", utm_term));
        this.mktoAttributes.add(new BasicNameValuePair("utm_campaign", utm_campaign));
        this.mktoAttributes.add(new BasicNameValuePair("utm_medium", utm_medium));
        this.mktoAttributes.add(new BasicNameValuePair("utm_source", utm_source));
    }

    @View
    public Response.Content index(SecurityContext securityContext, HttpContext httpContext) {
        Cookie[] cookies = httpContext.getCookies();
        String facebook_oauth_url = "";
        String google_oauth_url = "";
        String linkedin_oauth_url = "";
        String facebook_share_url = "";
        String google_share_url = "";
        String linkedin_share_url = "";
        this.mktoAttributes = new ArrayList();
        this.email_player = "";
        this.firstname_player = "";
        this.lastname_player = "";
        this.bannerUrl = "";
        this.isFinished = false;
        this.remoteUserName = null;
        if (null != securityContext.getUserPrincipal()) {
            this.remoteUserName = securityContext.getUserPrincipal().getName();
        }
        this.init();
        if (null != this.currentMissionId) {
            this.currentSettings = this.jcrService.getProgramSettings(this.currentProgramId);
            if (null != this.currentSettings) {
                String banner_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"banner_url");
                if (null != banner_url && !"".equals(banner_url)) {
                    this.bannerUrl = banner_url;
                }
                this.sizeOutOfStock = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"size_out_of_stock");
                this.save_user_data_endpoint = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"save_user_data_endpoint");
                this.save_user_data_endpoint_token = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"save_user_data_endpoint_token");
                this.save_user_data_request_method = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"save_user_data_request_method");
                facebook_oauth_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"facebook_oauth_url");
                google_oauth_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"google_oauth_url");
                linkedin_oauth_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"linkedin_oauth_url");
                facebook_share_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"facebook_share_url");
                google_share_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"google_share_url");
                linkedin_share_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"linkedin_share_url");
            }
            Boolean hasOauth = false;
            if (!("".equals(facebook_oauth_url) && "".equals(google_oauth_url) && "".equals(linkedin_oauth_url))) {
                hasOauth = true;
            }
            Boolean hasShare = false;
            if (!("".equals(facebook_share_url) && "".equals(google_share_url) && "".equals(linkedin_share_url))) {
                hasShare = true;
            }
            if (!"".equals(this.bannerUrl) && !this.checkBannerUrl(this.bannerUrl).booleanValue()) {
                this.bannerUrl = "";
            }
            return this.indexTpl.with().set("bannerUrl", (Object)this.bannerUrl).set("programTitle", (Object)this.currentProgramTitle).set("facebook_oauth_url", (Object)facebook_oauth_url).set("google_oauth_url", (Object)google_oauth_url).set("linkedin_oauth_url", (Object)linkedin_oauth_url).set("facebook_share_url", (Object)facebook_share_url).set("google_share_url", (Object)google_share_url).set("linkedin_share_url", (Object)linkedin_share_url).set("hasOauth", (Object)hasOauth).set("hasShare", (Object)hasShare).ok();
        }
        return Response.ok((CharSequence)"");
    }

    private Boolean checkBannerUrl(String bannerUrl) {
        try {
            URL url = new URL(bannerUrl);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("HEAD");
            int responseCode = huc.getResponseCode();
            if (responseCode == 200) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private Mission getRandomMission() {
        Mission mission = this.jcrService.getRandomMisson(this.currentProgramId, this.remoteUserName);
        if (null != mission) {
            this.currentMissionId = mission.getId();
            List propositions = mission.getPropositions();
            if (null != propositions && propositions.size() > 0) {
                this.currentPropositionId = ((Proposition)propositions.get(0)).getId();
                return mission;
            }
        }
        return null;
    }

    private void loadCurrentMission() {
        Mission mission;
        MissionParticipant missionParticipant = this.jcrService.getCurrentMissionParticipantByUserName(this.currentProgramId, this.remoteUserName);
        if (null != missionParticipant) {
            this.currentMissionParticipantId = missionParticipant.getId();
            this.currentMissionId = missionParticipant.getMission_id();
            this.currentMissionParticipantStatus = missionParticipant.getStatus().getLabel();
            this.currentPropositionId = missionParticipant.getProposition_id();
        } else if (null == this.currentMissionId && null == this.currentPropositionId && null != (mission = this.jcrService.getRandomMisson(this.currentProgramId, this.remoteUserName))) {
            this.currentMissionId = mission.getId();
            Proposition proposition = this.jcrService.getRandomProposition(this.currentMissionId);
            if (null != proposition) {
                this.currentPropositionId = proposition.getId();
            }
        }
    }

    private void loadCurrentProgram() {
        block0: {
            List programs = this.jcrService.getAllPrograms();
            Iterator iterator = programs.iterator();
            if (!iterator.hasNext()) break block0;
            Program program = (Program)iterator.next();
            this.currentProgramId = program.getId();
            this.currentProgramTitle = program.getTitle();
        }
    }

    public String checkSession() {
        return "";
    }

    @Ajax
    @Resource
    public Response.Content initView() {
        if (null != this.currentMissionId && null != this.currentPropositionId) {
            if (null == this.currentMissionParticipantId) {
                if (!this.getOrCreateMissionParticipant(this.currentMissionId).booleanValue()) {
                    return Response.ok((CharSequence)"something went wrong, please come back later");
                }
                return this.indexTpl.ok();
            }
            if (Status.OPEN.getLabel().equals(this.currentMissionParticipantStatus)) {
                Mission mission = this.getCurrentMission();
                return this.processTpl.with().set("mission", (Object)mission).ok();
            }
            if (Status.INPROGRESS.getLabel().equals(this.currentMissionParticipantStatus)) {
                return this.terminateTpl.with().set("sizes", (Object)Size.values()).ok();
            }
        }
        return Response.ok((CharSequence)"We are preparing next mission, please come back later");
    }

    @Ajax
    @Resource
    public Response.Content loadStepContainerView() {
        return this.stepContainerTpl.ok();
    }

    @Ajax
    @Resource
    public Response processOpenMission() {
        String session = this.checkSession();
        if ("".equals(session)) {
            if (!this.getOrCreateMissionParticipant(this.currentMissionId).booleanValue()) {
                return Response.ok((CharSequence)"nok");
            }
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)session);
    }

    @Ajax
    @Resource
    public Response loadProcessView() {
        Mission missionRandom = this.getCurrentMission();
        if (null != missionRandom) {
            return this.processTpl.with().set("mission", (Object)missionRandom).ok();
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response loadTerminateView() {
        String[] out_of_stock = new String[]{};
        if (null != this.sizeOutOfStock && !"".equals(this.sizeOutOfStock)) {
            out_of_stock = this.sizeOutOfStock.split(",");
        }
        return this.terminateTpl.with().set("sizes", (Object)Size.values()).set("size_out_of_stock", (Object)out_of_stock).ok();
    }

    @Ajax
    @Resource
    public Response executeMission() {
        String session = this.checkSession();
        if ("".equals(session)) {
            MissionParticipant missionParticipant;
            if (null != this.currentMissionParticipantId && null != (missionParticipant = this.jcrService.getMissionParticipantById(this.currentMissionParticipantId))) {
                missionParticipant.setStatus(Status.INPROGRESS);
                if (null != this.jcrService.updateMissionParticipantInProgram(this.currentProgramId, missionParticipant)) {
                    this.currentMissionParticipantStatus = Status.INPROGRESS.getLabel();
                    return Response.ok((CharSequence)"ok");
                }
            }
            return Response.ok((CharSequence)"nok");
        }
        return Response.ok((CharSequence)session);
    }

    @Ajax
    @Resource
    public Response completeMission(String url) {
        MissionParticipant missionParticipant;
        if (null != this.currentMissionParticipantId && null != (missionParticipant = this.jcrService.getMissionParticipantById(this.currentMissionParticipantId))) {
            missionParticipant.setStatus(Status.COMPLETE);
            missionParticipant.setUrl_submitted(url);
            if (null != this.jcrService.updateMissionParticipantInProgram(this.currentProgramId, missionParticipant)) {
                this.currentMissionParticipantStatus = Status.COMPLETE.getLabel();
                return Response.ok((CharSequence)"ok");
            }
        }
        if (this.jcrService.removeMissionParticipantInParticipant(this.currentProgramId, this.remoteUserName, this.currentMissionParticipantId).booleanValue()) {
            this.jcrService.removeMissionParticipant(this.currentMissionParticipantId);
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response terminate(String url, String fname, String lname, String email, String address, String city, String phone, String country, String size) {
        if (null == this.remoteUserName) {
            this.remoteUserName = email;
        }
        String session = this.checkSession();
        this.getOrCreateMissionParticipant(this.currentMissionId);
        if ("".equals(session)) {
            MissionParticipant missionParticipant;
            if (null != this.currentMissionParticipantId && null != (missionParticipant = this.jcrService.getMissionParticipantById(this.currentMissionParticipantId))) {
                missionParticipant.setProposition_id(this.currentPropositionId);
                Address addressObj = new Address(fname, lname, address, city, country, phone);
                addressObj = this.jcrService.addAddress2Participant(this.currentProgramId, this.remoteUserName, addressObj);
                if (null != addressObj) {
                    missionParticipant.setUrl_submitted(url);
                    missionParticipant.setStatus(Status.WAITING_FOR_VALIDATE);
                    missionParticipant.setAddress_id(addressObj.getId());
                    missionParticipant.setSize(Size.getSize((int)Integer.parseInt(size)));
                    if (null != this.jcrService.updateMissionParticipantInProgram(this.currentProgramId, missionParticipant)) {
                        Participant participant = new Participant(this.remoteUserName);
                        participant.setProgramId(this.currentProgramId);
                        HashSet<String> missionIds = new HashSet<String>();
                        missionIds.add(this.currentMissionId);
                        participant.setMission_ids(missionIds);
                        HashSet<String> missionParticipantIds = new HashSet<String>();
                        missionParticipantIds.add(this.currentMissionParticipantId);
                        participant.setMission_participant_ids(missionParticipantIds);
                        if (null != this.jcrService.addParticipant2Program(participant) && null != this.updateCurrentProposition()) {
                            this.mktoAttributes.add(new BasicNameValuePair("partner_key", this.save_user_data_endpoint_token));
                            this.mktoAttributes.add(new BasicNameValuePair("email", email));
                            this.mktoAttributes.add(new BasicNameValuePair("first_name", fname));
                            this.mktoAttributes.add(new BasicNameValuePair("last_name", lname));
                            this.mktoAttributes.add(new BasicNameValuePair("phone", phone));
                            this.mktoAttributes.add(new BasicNameValuePair("address", address));
                            this.mktoAttributes.add(new BasicNameValuePair("city", city));
                            this.mktoAttributes.add(new BasicNameValuePair("country", country));
                            return Response.ok((CharSequence)"ok");
                        }
                    }
                }
            }
            if (this.jcrService.removeMissionParticipantInParticipant(this.currentProgramId, this.remoteUserName, this.currentMissionParticipantId).booleanValue()) {
                this.jcrService.removeMissionParticipant(this.currentMissionParticipantId);
            }
            return Response.ok((CharSequence)"nok");
        }
        return Response.ok((CharSequence)session);
    }

    @Ajax
    @Resource
    public Response loadThankyouView() {
        return this.thankyouTpl.ok();
    }

    private Boolean getOrCreateMissionParticipant(String missionId) {
        MissionParticipant missionParticipant = this.jcrService.getCurrentMissionParticipantByMissionId(this.currentProgramId, missionId, this.remoteUserName);
        if (null == missionParticipant) {
            missionParticipant = new MissionParticipant();
            missionParticipant.setMission_id(missionId);
            missionParticipant.setParticipant_username(this.remoteUserName);
            missionParticipant = this.jcrService.addMissionParticipant2Program(this.currentProgramId, missionParticipant);
            if (null != missionParticipant) {
                Participant participant = new Participant(this.remoteUserName);
                participant.setProgramId(this.currentProgramId);
                HashSet missionIds = new HashSet();
                participant.setMission_ids(missionIds);
                HashSet<String> missionParticipantIds = new HashSet<String>();
                missionParticipantIds.add(missionParticipant.getId());
                participant.setMission_participant_ids(missionParticipantIds);
                if (null != this.jcrService.addParticipant2Program(participant)) {
                    this.currentMissionParticipantId = missionParticipant.getId();
                    this.currentMissionParticipantStatus = Status.OPEN.getLabel();
                    return true;
                }
                if (null == this.currentMissionParticipantId) {
                    this.jcrService.removeMissionParticipant(missionParticipant.getId());
                }
            }
        } else {
            this.currentMissionParticipantId = missionParticipant.getId();
            this.currentMissionParticipantStatus = Status.OPEN.getLabel();
            return true;
        }
        return false;
    }

    private Proposition updateCurrentProposition() {
        Proposition proposition = this.jcrService.getPropositionById(this.currentPropositionId);
        if (null != proposition) {
            proposition.setNumberUsed(proposition.getNumberUsed() + 1);
            return this.jcrService.updateProposition(proposition);
        }
        return null;
    }

    private Mission getCurrentMission() {
        Mission randomMission = null;
        Proposition randomProposition = null;
        if (null != this.currentMissionId) {
            ArrayList<Proposition> propositions = new ArrayList<Proposition>(1);
            randomMission = this.jcrService.getMissionById(this.currentMissionId);
            if (null != this.currentPropositionId && null != (randomProposition = this.jcrService.getPropositionById(this.currentPropositionId))) {
                propositions.add(randomProposition);
                randomMission.setPropositions(propositions);
                return randomMission;
            }
        }
        return null;
    }

    @Ajax
    @Resource
    public Response sendNotifEmail(HttpContext httpContext, String disableUTMCookie, String utm_content, String utm_term, String utm_campaign, String utm_medium, String utm_source) {
        if (this.jcrService.sendNotifMissionParticipantEmail(this.currentSettings, this.currentMissionParticipantId, "").booleanValue()) {
            if (null != this.save_user_data_endpoint && !"".equals(this.save_user_data_endpoint) && null != this.save_user_data_endpoint_token || !"".equals(this.save_user_data_endpoint_token)) {
                if ("false".equals(disableUTMCookie)) {
                    this.initUTMCookie(httpContext);
                } else {
                    this.mktoAttributes.add(new BasicNameValuePair("utm_content", utm_content));
                    this.mktoAttributes.add(new BasicNameValuePair("utm_term", utm_term));
                    this.mktoAttributes.add(new BasicNameValuePair("utm_campaign", utm_campaign));
                    this.mktoAttributes.add(new BasicNameValuePair("utm_medium", utm_medium));
                    this.mktoAttributes.add(new BasicNameValuePair("utm_source", utm_source));
                }
                ApacheHttpClient.sendRequest((String)this.save_user_data_endpoint, (String)this.save_user_data_endpoint_token, (String)this.save_user_data_request_method, (List)this.mktoAttributes);
            }
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response sendNotifAlmostMissionDoneEmail() {
        if (this.jcrService.sendNotifAlmostMissionDoneEmail(this.currentProgramId, this.remoteUserName).booleanValue()) {
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response generateNewMission() {
        String session = this.checkSession();
        if ("".equals(session)) {
            this.init();
            if (null != this.currentMissionId) {
                return Response.ok((CharSequence)"ok");
            }
            return Response.ok((CharSequence)"nok");
        }
        return Response.ok((CharSequence)session);
    }
}

