/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.caldav.service;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.caldav.model.CaldavUserSetting;
import org.exoplatform.caldav.service.CaldavConnectorService;
import org.exoplatform.caldav.storage.CaldavConnectorStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CaldavConnectorServiceImpl
implements CaldavConnectorService {
    private CaldavConnectorStorage caldavConnectorStorage;
    private static final Log LOG = ExoLogger.getLogger(CaldavConnectorServiceImpl.class);
    private String caldavUrl;

    public CaldavConnectorServiceImpl(CaldavConnectorStorage caldavConnectorStorage) {
        String caldavUrl = System.getProperty("exo.agenda.caldav.connector.url");
        this.caldavConnectorStorage = caldavConnectorStorage;
        this.caldavUrl = caldavUrl;
    }

    public void createCaldavSetting(CaldavUserSetting caldavUserSetting, long userIdentityId) throws IllegalAccessException {
        if (!StringUtils.isNotBlank((CharSequence)caldavUserSetting.getPassword()) || !StringUtils.isNotBlank((CharSequence)caldavUserSetting.getUsername())) {
            throw new IllegalAccessException("username or password not be null");
        }
        this.caldavConnectorStorage.createCaldavSetting(caldavUserSetting, userIdentityId);
    }

    public CaldavUserSetting getCaldavSetting(long userIdentityId) {
        CaldavUserSetting caldavUserSetting = this.caldavConnectorStorage.getCaldavSetting(userIdentityId);
        caldavUserSetting.setCaldavUrl(this.caldavUrl);
        return caldavUserSetting;
    }

    public void deleteCaldavSetting(long userIdentityId) {
        this.caldavConnectorStorage.deleteCaldavSetting(userIdentityId);
    }
}

