/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.caldav.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.caldav.model.CaldavUserSetting;
import org.exoplatform.caldav.service.CaldavConnectorService;
import org.exoplatform.caldav.utils.CaldavConnectorUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/v1/caldav")
public class CaldavConnectorRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(CaldavConnectorRest.class);
    private CaldavConnectorService caldavConnectorService;
    private IdentityManager identityManager;

    public CaldavConnectorRest(CaldavConnectorService caldavConnectorService, IdentityManager identityManager) {
        this.caldavConnectorService = caldavConnectorService;
        this.identityManager = identityManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Create caldav user setting", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createCaldavSetting(@Parameter(description="Caldav user setting object to create", required=true) CaldavUserSetting caldavUserSetting) {
        if (caldavUserSetting == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        long identityId = CaldavConnectorUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.caldavConnectorService.createCaldavSetting(caldavUserSetting, identityId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating caldav user setting ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Get caldav user setting", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCaldavSetting() {
        long identityId = CaldavConnectorUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            return Response.ok((Object)this.caldavConnectorService.getCaldavSetting(identityId)).build();
        }
        catch (Exception e) {
            LOG.error("Error when retrieving caldav user settings for user with id '{}'", new Object[]{identityId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete caldav user setting", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteCaldavSetting() {
        long identityId = CaldavConnectorUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.caldavConnectorService.deleteCaldavSetting(identityId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when deleting caldav user setting for user with id '{}'", new Object[]{identityId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

