/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.portlet.chat;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;

@Named(value="calendarService")
@ApplicationScoped
public class CalendarService {
    org.exoplatform.calendar.service.CalendarService calendarService_;
    OrganizationService organizationService_;
    Logger log = Logger.getLogger("CalendarService");

    @Inject
    public CalendarService(org.exoplatform.calendar.service.CalendarService calendarService, OrganizationService organizationService) {
        this.calendarService_ = calendarService;
        this.organizationService_ = organizationService;
    }

    protected void saveEvent(String user, String calName, String summary, Date from, Date to) throws Exception {
        String calId = this.getCalendarId(user, calName);
        if (calId != null) {
            CalendarEvent event = new CalendarEvent();
            event.setCalendarId(calId);
            event.setSummary(summary);
            event.setEventType(CalendarEvent.TYPE_TASK);
            event.setRepeatType(CalendarEvent.RP_NOREPEAT);
            event.setPrivate(true);
            event.setFromDateTime(from);
            event.setToDateTime(to);
            event.setPriority(CalendarEvent.PRIORITY_NORMAL);
            event.setTaskDelegator(user);
            event.setDescription("Created by " + user);
            this.calendarService_.savePublicEvent(calId, event, true);
        }
    }

    protected void saveTask(String currentUser, String username, String summary, Date from, Date to) throws Exception {
        String calId = this.getFirstCalendarsId(username);
        if (calId != null) {
            CalendarEvent task = new CalendarEvent();
            task.setCalendarId(calId);
            task.setSummary(summary);
            task.setEventType(CalendarEvent.TYPE_TASK);
            task.setRepeatType(CalendarEvent.RP_NOREPEAT);
            task.setPrivate(true);
            task.setFromDateTime(from);
            task.setToDateTime(to);
            task.setPriority(CalendarEvent.PRIORITY_NORMAL);
            task.setTaskDelegator(currentUser);
            task.setDescription("Created by " + currentUser + " for " + username);
            this.calendarService_.saveUserEvent(username, calId, task, true);
        }
    }

    private String getFirstCalendarsId(String username) {
        StringBuilder sb = new StringBuilder();
        List listUserCalendar = null;
        try {
            listUserCalendar = this.calendarService_.getUserCalendars(username, true);
            if (listUserCalendar.size() > 0) {
                return ((Calendar)listUserCalendar.get(0)).getId();
            }
        }
        catch (Exception e) {
            this.log.info("Error while checking User Calendar :" + e.getMessage());
        }
        return null;
    }

    private String getCalendarId(String username, String space) {
        String id = null;
        StringBuilder sb = new StringBuilder();
        List listgroupCalendar = null;
        try {
            listgroupCalendar = this.calendarService_.getGroupCalendars(this.getUserGroups(username), true, username);
        }
        catch (Exception e) {
            this.log.info("Error while checking User Calendar :" + e.getMessage());
        }
        for (GroupCalendarData g : listgroupCalendar) {
            for (Calendar c : g.getCalendars()) {
                if (!space.equals(c.getName())) continue;
                id = c.getId();
            }
        }
        return id;
    }

    private String[] getUserGroups(String username) throws Exception {
        Object[] objs = this.organizationService_.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }
}

