/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.portlet.notification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.request.RenderContext;
import juzu.template.Template;
import org.benjp.listener.ServerBootstrap;
import org.benjp.model.SpaceBean;
import org.benjp.model.SpaceBeans;
import org.benjp.portlet.notification.BundleService;
import org.benjp.utils.PropertyManager;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@SessionScoped
public class NotificationApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    String token_ = "---";
    String remoteUser_ = null;
    boolean profileInitialized_ = false;
    OrganizationService organizationService_;
    SpaceService spaceService_;
    @Inject
    BundleService bundleService_;
    @Inject
    Provider<PortletPreferences> providerPreferences;

    @Inject
    public NotificationApplication(OrganizationService organizationService, SpaceService spaceService) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
    }

    @View
    public void index(RenderContext renderContext) throws IOException {
        String chatServerURL = PropertyManager.getProperty((String)"chatServerUrl");
        String chatPage = PropertyManager.getProperty((String)"chatPortalPage");
        this.remoteUser_ = renderContext.getSecurityContext().getRemoteUser();
        String chatIntervalStatus = PropertyManager.getProperty((String)"chatIntervalStatus");
        String chatIntervalNotif = PropertyManager.getProperty((String)"chatIntervalNotif");
        String chatWeemoKey = PropertyManager.getProperty((String)"weemoKey");
        PortletPreferences portletPreferences = (PortletPreferences)this.providerPreferences.get();
        String title = portletPreferences.getValue("title", "---");
        Locale locale = renderContext.getUserContext().getLocale();
        ResourceBundle bundle = renderContext.getApplicationContext().resolveBundle(locale);
        String messages = this.bundleService_.getBundle("chatBundleData", bundle, locale);
        this.index.with().set("user", (Object)this.remoteUser_).set("token", (Object)this.token_).set("chatServerURL", (Object)chatServerURL).set("chatPage", (Object)chatPage).set("chatIntervalStatus", (Object)chatIntervalStatus).set("chatIntervalNotif", (Object)chatIntervalNotif).set("weemoKey", (Object)chatWeemoKey).set("title", (Object)title).set("messages", (Object)messages).render();
    }

    @Ajax
    @Resource
    public Response.Content initUserProfile() {
        String out = "{\"token\": \"" + this.token_ + "\", \"msg\": \"nothing to update\"}";
        if (!this.profileInitialized_) {
            try {
                this.token_ = ServerBootstrap.getToken((String)this.remoteUser_);
                this.addUser(this.remoteUser_, this.token_);
                this.saveFullNameAndEmail(this.remoteUser_);
                this.saveSpaces(this.remoteUser_);
                out = "{\"token\": \"" + this.token_ + "\", \"msg\": \"updated\"}";
                this.profileInitialized_ = true;
            }
            catch (Exception e) {
                this.profileInitialized_ = false;
                return Response.notFound((CharSequence)"Error during init, try later");
            }
        }
        return Response.ok((CharSequence)out).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    protected void addUser(String remoteUser, String token) {
        ServerBootstrap.addUser((String)remoteUser, (String)token);
    }

    protected String saveFullNameAndEmail(String username) {
        String fullname = username;
        try {
            fullname = ServerBootstrap.getUserFullName((String)username);
            if (fullname == null) {
                User user = this.organizationService_.getUserHandler().findUserByName(username);
                fullname = user.getFirstName() + " " + user.getLastName();
                ServerBootstrap.addUserFullNameAndEmail((String)username, (String)fullname, (String)user.getEmail());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fullname;
    }

    protected void saveSpaces(String username) {
        try {
            ListAccess spacesListAccess = this.spaceService_.getAccessibleSpacesWithListAccess(username);
            List<Object> spaces = Arrays.asList(spacesListAccess.load(0, spacesListAccess.getSize()));
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            for (Space space : spaces) {
                SpaceBean spaceBean = new SpaceBean();
                spaceBean.setDisplayName(space.getDisplayName());
                spaceBean.setGroupId(space.getGroupId());
                spaceBean.setId(space.getId());
                spaceBean.setShortName(space.getShortName());
                beans.add(spaceBean);
            }
            ServerBootstrap.setSpaces((String)username, (SpaceBeans)new SpaceBeans(beans));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

