/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.portlet.notification;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import juzu.Path;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.ApplicationContext;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.chat.portlet.notification.BundleService;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;

@SessionScoped
public class NotificationApplication {
    private static final Logger LOG = Logger.getLogger(NotificationApplication.class.getName());
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    boolean standaloneChatServer;
    String token_ = "---";
    String remoteUser_ = null;
    boolean profileInitialized_ = false;
    String chatCometDServerUrl;
    String chatServerURI;
    String chatPage;
    String plfUserStatusUpdateUrl;
    OrganizationService organizationService_;
    SpaceService spaceService_;
    String dbName;
    @Inject
    BundleService bundleService_;
    @Inject
    ContinuationService continuationService;
    @Inject
    Provider<PortletPreferences> providerPreferences;

    @Inject
    public NotificationApplication(OrganizationService organizationService, SpaceService spaceService) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.dbName = ServerBootstrap.getDBName();
        this.standaloneChatServer = Boolean.valueOf(PropertyManager.getProperty((String)"standaloneChatServer"));
        this.chatServerURI = ServerBootstrap.getServerURI();
        this.chatPage = PropertyManager.getProperty((String)"chatPortalPage");
        this.plfUserStatusUpdateUrl = PropertyManager.getProperty((String)"plfUsrStatUpdUrl");
        this.chatCometDServerUrl = this.standaloneChatServer ? this.chatServerURI : "/cometd";
    }

    @View
    public Response.Content index(ApplicationContext applicationContext, SecurityContext securityContext, UserContext userContext) throws IOException {
        this.remoteUser_ = securityContext.getRemoteUser();
        this.initUserProfile();
        PortletPreferences portletPreferences = (PortletPreferences)this.providerPreferences.get();
        String title = portletPreferences.getValue("title", "---");
        Locale locale = userContext.getLocale();
        ResourceBundle bundle = applicationContext.resolveBundle(locale);
        String messages = this.bundleService_.getBundle("chatBundleData", bundle, locale);
        Space space = SpaceUtils.getSpaceByContext();
        String spaceId = space == null ? "" : space.getPrettyName();
        String portalURI = Util.getPortalRequestContext().getPortalURI();
        String cometdToken = this.standaloneChatServer ? this.token_ : this.continuationService.getUserToken(this.remoteUser_);
        return this.index.with().set("user", (Object)this.remoteUser_).set("token", (Object)this.token_).set("standalone", (Object)this.standaloneChatServer).set("chatCometDServerUrl", (Object)this.chatCometDServerUrl).set("cometdToken", (Object)cometdToken).set("chatServerURL", (Object)this.chatServerURI).set("chatPage", (Object)this.chatPage).set("plfUserStatusUpdateUrl", (Object)this.plfUserStatusUpdateUrl).set("title", (Object)title).set("messages", (Object)messages).set("spaceId", (Object)spaceId).set("sessionId", (Object)Util.getPortalRequestContext().getRequest().getSession().getId()).set("dbName", (Object)this.dbName).set("portalURI", (Object)portalURI).ok().withCharset(Tools.UTF_8);
    }

    public void initUserProfile() {
        if (!this.profileInitialized_) {
            try {
                this.token_ = ServerBootstrap.getToken((String)this.remoteUser_);
                ServerBootstrap.addUser((String)this.remoteUser_, (String)this.token_, (String)this.dbName);
                this.saveFullNameAndEmail(this.remoteUser_, this.dbName);
                ServerBootstrap.saveSpaces((String)this.remoteUser_, (String)this.dbName);
                this.profileInitialized_ = true;
            }
            catch (Exception e) {
                this.profileInitialized_ = false;
            }
        }
    }

    protected String saveFullNameAndEmail(String username, String dbName) {
        String fullname = username;
        try {
            fullname = ServerBootstrap.getUserFullName((String)username, (String)dbName);
            if (fullname == null || fullname.isEmpty()) {
                User user = this.organizationService_.getUserHandler().findUserByName(username);
                fullname = user.getFirstName() + " " + user.getLastName();
                ServerBootstrap.addUserFullNameAndEmail((String)username, (String)fullname, (String)user.getEmail(), (String)dbName);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
        return fullname;
    }
}

