##########################################################################
## 
##  WEEMO INC.
## 
##  Shell script to remove WeemoDriver on MacOS
##  [2013] Weemo Inc.
##  All Rights Reserved.
## 
## NOTICE:  All information contained herein is, and remains
## the property of Weemo Inc.
## The intellectual and technical concepts contained
## herein are proprietary to Weemo Inc.
## Dissemination of this information or reproduction of this material
## is strictly forbidden unless prior written permission is obtained
## from Weemo Inc.
##
##########################################################################

#!/bin/sh                                 
                                                                                                    
if [ -a /Library/Application\ Support/Weemo/WeemoDriver.app ]
	then
		echo 'Installed WeemoDriver version: ' 
		tail -n3 /Library/Application\ Support/Weemo/WeemoDriver.app/Contents/Info.plist | awk '{ print substr( $0, 10, 7 ) }'
		pid=$(ps -fe | grep 'WeemoDriver' | awk '{print $2}')
		uid=$(ps aux | grep 'WeemoDriver' | awk '{print substr($0, 0, 25)}')
		wuid=${uid:0:4}

		declare -i uidlen=$(echo $uid | wc -c | awk '{print substr($1, 0, 2)}')
		declare -i minlen=14

		if [ $uidlen -gt $minlen ]; then

	    	if [[ -n $wuid ]]; then

				if [ "$wuid" == "root" ]; then

		    		echo 'WeemoDriver is running as root.'

		    		if [ "$USER" == $wuid ]; then
						echo 'Removing WeemoDriver as root...'
						pkill -f "WeemoDriver" > /dev/null 2>&1
						launchctl remove com.Weemo.WeemoDriver > /dev/null 2>&1
						sleep 1
						sudo rm -rf /Library/Application\ Support/Weemo
						sleep 1
						sudo rm -f /System/Library/LaunchAgents/com.Weemo.WeemoDriver.plist 
						sleep 1
						echo 'WeemoDriver removed.'
			    	else
						echo 'Relaunching this script as root...'
			  	  		echo 'Enter your root password and press [Enter]:'
			    		read -s passwd
			    		eval echo -e $passwd | sudo -S sh weemo_remove.sh  
			    	fi
				else
				    echo 'WeemoDriver is not running as root'
				    echo 'Trying to remove as current user: '$USER
				    pkill -f "WeemoDriver" > /dev/null 2>&1
				    launchctl remove com.Weemo.WeemoDriver > /dev/null 2>&1
				    sleep 1
				    sudo rm -rf /Library/Application\ Support/Weemo
					sleep 1
					sudo rm -f /System/Library/LaunchAgents/com.Weemo.WeemoDriver.plist 
					sleep 1
				    echo 'WeemoDriver removed.'
				fi
			else
				echo 'WeemoDriver is not running!'
	    	fi
		else
	   		echo 'WeemoDriver is not running!'
		fi
	else
		echo 'WeemoDriver is not installed.'
fi

