/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.utils;

import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyManagerTestCase {
    @Before
    public void before() {
        PropertyManager.forceReload();
    }

    @After
    public void after() {
        PropertyManager.forceReload();
    }

    @Test
    public void testLoadSystemProperties() {
        System.setProperty("exo.dbServerHost", "localhost");
        System.setProperty("chat.dbServerPort", "1234");
        String dbServerHost = PropertyManager.getProperty((String)"dbServerHost");
        String dbServerPort = PropertyManager.getProperty((String)"dbServerPort");
        Assert.assertEquals((Object)"localhost", (Object)dbServerHost);
        Assert.assertEquals((Object)"1234", (Object)dbServerPort);
    }

    @Test
    public void testoverrideProperty() {
        System.setProperty("dbPassword", "pass");
        PropertyManager.overrideProperty((String)"dbPassword", (String)"pass2");
        String dbPassword = PropertyManager.getProperty((String)"dbPassword");
        Assert.assertEquals((Object)"pass2", (Object)dbPassword);
    }

    @Test
    public void testDefaultProperties() {
        Assert.assertEquals((Object)"mongo", (Object)PropertyManager.getProperty((String)"servicesImplementation"));
        Assert.assertEquals((Object)"mongo", (Object)PropertyManager.getProperty((String)"dbServerType"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"dbServerHost"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"dbServerHosts"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"dbServerPort"));
        Assert.assertEquals((Object)"chat", (Object)PropertyManager.getProperty((String)"dbName"));
        Assert.assertEquals((Object)"false", (Object)PropertyManager.getProperty((String)"dbAuthentication"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"dbUser"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"dbPassword"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"chatServerBase"));
        Assert.assertEquals((Object)"/chatServer", (Object)PropertyManager.getProperty((String)"chatServerUrl"));
        Assert.assertEquals((Object)"/portal/intranet/chat", (Object)PropertyManager.getProperty((String)"chatPortalPage"));
        Assert.assertEquals((Object)"60000", (Object)PropertyManager.getProperty((String)"chatIntervalSession"));
        Assert.assertEquals((Object)"chat", (Object)PropertyManager.getProperty((String)"chatPassPhrase"));
        Assert.assertEquals((Object)"0 0 * * * ?", (Object)PropertyManager.getProperty((String)"chatCronNotifCleanup"));
        Assert.assertEquals((Object)"/platform/administrators", (Object)PropertyManager.getProperty((String)"publicAdminGroup"));
        Assert.assertEquals((Object)"/platform/users", (Object)PropertyManager.getProperty((String)"teamAdminGroup"));
        Assert.assertEquals((Object)"60000", (Object)PropertyManager.getProperty((String)"chatTokenValidity"));
        Assert.assertEquals((Object)"200", (Object)PropertyManager.getProperty((String)"chatReadTotalJson"));
        Assert.assertEquals((Object)"2000", (Object)PropertyManager.getProperty((String)"chatReadTotalTxt"));
        Assert.assertEquals((Object)"smtp", (Object)PropertyManager.getProperty((String)"email.smtp.protocal"));
        Assert.assertEquals((Object)"localhost", (Object)PropertyManager.getProperty((String)"email.smtp.host"));
        Assert.assertEquals((Object)"25", (Object)PropertyManager.getProperty((String)"email.smtp.port"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"email.smtp.username"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"email.smtp.password"));
        Assert.assertEquals((Object)"eXo Platform", (Object)PropertyManager.getProperty((String)"email.smtp.from"));
        Assert.assertEquals((Object)"false", (Object)PropertyManager.getProperty((String)"email.smtp.starttls.enable"));
        Assert.assertEquals((Object)"true", (Object)PropertyManager.getProperty((String)"email.smtp.EnableSSL.enable"));
        Assert.assertEquals((Object)"false", (Object)PropertyManager.getProperty((String)"email.smtp.auth"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"email.smtp.socketFactory.port"));
        Assert.assertEquals((Object)"", (Object)PropertyManager.getProperty((String)"email.smtp.socketFactory.class"));
        Assert.assertEquals((Object)"false", (Object)PropertyManager.getProperty((String)"email.smtp.socketFactory.fallback"));
        Assert.assertEquals((Object)"eXo Platform", (Object)PropertyManager.getProperty((String)"email.smtp.from"));
        Assert.assertEquals((Object)"/portal/rest/state/status/", (Object)PropertyManager.getProperty((String)"plfUsrStatUpdUrl"));
        Assert.assertEquals((Object)"15000", (Object)PropertyManager.getProperty((String)"request.timeout"));
        Assert.assertNull((Object)PropertyManager.getProperty((String)"No key"));
        Assert.assertEquals((Object)"640ab2bae07bedc4c163f679a746f7ab7fb5d1fa", (Object)MessageDigester.getHash((String)"Test"));
    }
}

