/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.utils.ChatUtils;
import org.junit.Assert;
import org.junit.Test;

public class ChatUtilsTest {
    @Test
    public void testFromString() throws IOException, ClassNotFoundException {
        SpaceBean space = new SpaceBean();
        space.setDisplayName("space 1");
        space.setGroupId("/spaces/space_1");
        space.setId("1");
        space.setShortName("space_1");
        space.setPrettyName("space_1");
        space.setTimestamp(-1L);
        ArrayList<SpaceBean> spaces = new ArrayList<SpaceBean>();
        spaces.add(space);
        SpaceBeans beans = new SpaceBeans(spaces);
        String input = "rO0ABXNyACVvcmcuZXhvcGxhdGZvcm0uY2hhdC5tb2RlbC5TcGFjZUJlYW5zUs3d0MH0nzYCAAFMAAdzcGFjZXNfdAAVTGphdmEvdXRpbC9BcnJheUxpc3Q7eHBzcgATamF2YS51dGlsLkFycmF5TGlzdHiB0h2Zx2GdAwABSQAEc2l6ZXhwAAAAAXcEAAAAAXNyACRvcmcuZXhvcGxhdGZvcm0uY2hhdC5tb2RlbC5TcGFjZUJlYW7cTcoLVb0cWwIACVoADm1lZXRpbmdTdGFydGVkSgAJdGltZXN0YW1wTAALZGlzcGxheU5hbWV0ABJMamF2YS9sYW5nL1N0cmluZztMAAdncm91cElkcQB+AAZMAAJpZHEAfgAGTAAKcHJldHR5TmFtZXEAfgAGTAAEcm9vbXEAfgAGTAAJc2hvcnROYW1lcQB+AAZMAAlzdGFydFRpbWVxAH4ABnhwAP//////////dAAHc3BhY2UgMXQADy9zcGFjZXMvc3BhY2VfMXQAATF0AAdzcGFjZV8xcHEAfgALdAAAeA==";
        SpaceBeans outputObj = (SpaceBeans)ChatUtils.fromString((String)input);
        Assert.assertEquals((Object)beans.getSpaces(), (Object)outputObj.getSpaces());
    }

    @Test
    public void testToString() throws IOException {
        SpaceBean space = new SpaceBean();
        space.setDisplayName("space 1");
        space.setGroupId("/spaces/space_1");
        space.setId("1");
        space.setShortName("space_1");
        space.setPrettyName("space_1");
        space.setTimestamp(-1L);
        ArrayList<SpaceBean> spaces = new ArrayList<SpaceBean>();
        spaces.add(space);
        SpaceBeans beans = new SpaceBeans(spaces);
        String outputObj = ChatUtils.toString((Serializable)beans);
        String expected = "rO0ABXNyACVvcmcuZXhvcGxhdGZvcm0uY2hhdC5tb2RlbC5TcGFjZUJlYW5zUs3d0MH0nzYCAAFMAAdzcGFjZXNfdAAVTGphdmEvdXRpbC9BcnJheUxpc3Q7eHBzcgATamF2YS51dGlsLkFycmF5TGlzdHiB0h2Zx2GdAwABSQAEc2l6ZXhwAAAAAXcEAAAAAXNyACRvcmcuZXhvcGxhdGZvcm0uY2hhdC5tb2RlbC5TcGFjZUJlYW7cTcoLVb0cWwIACVoADm1lZXRpbmdTdGFydGVkSgAJdGltZXN0YW1wTAALZGlzcGxheU5hbWV0ABJMamF2YS9sYW5nL1N0cmluZztMAAdncm91cElkcQB+AAZMAAJpZHEAfgAGTAAKcHJldHR5TmFtZXEAfgAGTAAEcm9vbXEAfgAGTAAJc2hvcnROYW1lcQB+AAZMAAlzdGFydFRpbWVxAH4ABnhwAP//////////dAAHc3BhY2UgMXQADy9zcGFjZXMvc3BhY2VfMXQAATF0AAdzcGFjZV8xcHEAfgALdAAAeA==";
        Assert.assertEquals((Object)expected, (Object)outputObj);
    }

    @Test
    public void testGetRoomIdWithRoomNameAndUser() {
        String user = "user";
        String roomName = "room";
        String expected = "9decec739237f5ff6f0cc01944fd7cae5eb46f97";
        String roomID = ChatUtils.getRoomId((String)roomName, (String)user);
        Assert.assertEquals((Object)expected, (Object)roomID);
    }

    @Test
    public void testGetRoomIdWithRoomName() {
        String roomName = "room";
        String expected = "27442e996a1f3699be82deb2502bd8e8e7a3c532";
        String roomID = ChatUtils.getRoomId((String)roomName);
        Assert.assertEquals((Object)expected, (Object)roomID);
    }

    @Test
    public void testGetExternalRoomId() {
        String roomName = "room";
        String expected = "9f8d540666d9623830d6e07981779df595333f23";
        String roomID = ChatUtils.getExternalRoomId((String)roomName);
        Assert.assertEquals((Object)expected, (Object)roomID);
    }
}

