/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.bean;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringEscapeUtils;

public class File
implements Comparable<File> {
    String title;
    String name;
    String owner;
    Calendar createdDate;
    String sizeLabel;
    Long size;
    String path;
    String uuid = "";
    String publicUrl;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreatedDateAsDate() {
        return this.createdDate.getTime();
    }

    public String getCreatedDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("d/M/yy hh:mm aaa");
        return formatter.format(this.createdDate.getTime());
    }

    public void setCreatedDate(Calendar createdDate) {
        this.createdDate = createdDate;
    }

    public String getSizeLabel() {
        return this.sizeLabel;
    }

    public void setSizeLabel(String sizeLabel) {
        this.sizeLabel = sizeLabel;
    }

    public String getRestPath() {
        return "/portal/rest/jcr/repository/collaboration" + this.path;
    }

    public String getDownloadLink() {
        return "/portal/rest/private/contents/download/collaboration" + this.path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getOwner() {
        if (this.owner == null || "".equals(this.owner)) {
            return "Someone";
        }
        return this.owner.substring(0, 1).toUpperCase() + this.owner.substring(1);
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public int compareTo(File file) {
        return this.getName().compareToIgnoreCase(file.getName());
    }

    public String toJSON() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\"status\": \"ok\",");
        sb.append("\"name\": \"" + this.getName() + "\",");
        sb.append("\"title\": \"" + StringEscapeUtils.escapeJson((String)StringEscapeUtils.escapeHtml4((String)this.getTitle())) + "\",");
        sb.append("\"size\": " + this.getSize() + ",");
        sb.append("\"owner\": \"" + this.getOwner() + "\",");
        sb.append("\"createdDate\": \"" + this.getCreatedDate() + "\",");
        sb.append("\"restPath\": \"" + this.getRestPath() + "\",");
        sb.append("\"downloadLink\": \"" + this.getDownloadLink() + "\",");
        sb.append("\"uuid\": \"" + this.getUuid() + "\",");
        sb.append("\"path\": \"" + this.getPath() + "\",");
        sb.append("\"publicUrl\": \"" + this.getPublicUrl() + "\",");
        sb.append("\"sizeLabel\": \"" + this.getSizeLabel() + "\"");
        sb.append("}");
        return sb.toString();
    }
}

