/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.api;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.addons.chat.model.MentionModel;
import org.exoplatform.addons.chat.utils.MessageDigester;
import org.exoplatform.addons.chat.utils.NotificationUtils;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.service.DocumentService;
import org.exoplatform.chat.service.WikiService;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.json.simple.JSONObject;

@Path(value="/chat/api/1.0/user/")
public class UserRestService
implements ResourceContainer {
    private static final String CHAT_USER_INITIALIZATION_ATTR = "exo.chat.user.initialized";
    public static final String ANONIM_USER = "__anonim_";
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private DocumentService documentService;
    private WikiService wikiService;
    private OrganizationService organizationService;
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager;
    private ContinuationService continuationService;
    private UserStateService userStateService;

    public UserRestService(UserStateService userStateService, RelationshipManager relationshipManager, IdentityManager identityManager, ContinuationService continuationService, OrganizationService organizationService) {
        this.organizationService = organizationService;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
        this.continuationService = continuationService;
        this.userStateService = userStateService;
    }

    @GET
    @Path(value="/token/")
    public Response getToken(@Context HttpServletRequest request, @QueryParam(value="tokenOnly") String tokenOnly) throws Exception {
        String token;
        boolean withTokenOnly;
        this.init(request);
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        boolean bl = withTokenOnly = tokenOnly != null && "true".equals(tokenOnly);
        if ("__anonim".equals(userId)) {
            userId = ANONIM_USER;
            token = "---";
        } else {
            String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        }
        if (withTokenOnly) {
            return Response.ok((Object)token, (String)"text/plain").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        JSONObject data = new JSONObject();
        data.put((Object)"username", (Object)userId);
        data.put((Object)"token", (Object)token);
        return Response.ok((Object)data.toString(), (String)"application/json").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/cometdToken/")
    @RolesAllowed(value={"users"})
    public Response getCometdToken(@Context HttpServletRequest request) throws Exception {
        this.init(request);
        String token = this.getCometdToken();
        return Response.ok((Object)token, (String)"text/plain").build();
    }

    @GET
    @Path(value="/onlineStatus/")
    @RolesAllowed(value={"users"})
    public Response getOnlineStatus(@Context HttpServletRequest request, @QueryParam(value="users") String users) throws Exception {
        this.init(request);
        if (users != null) {
            String[] split = users.split(",");
            JSONObject data = new JSONObject();
            for (String u : split) {
                data.put((Object)u, (Object)this.userStateService.isOnline(u));
            }
            return Response.ok((Object)data.toString(), (String)"application/json").build();
        }
        return Response.serverError().status(400).build();
    }

    @POST
    @Path(value="/mentionNotifications")
    @RolesAllowed(value={"users"})
    public Response sendNotificationToMentionUsers(@Context HttpServletRequest request, @ApiParam(value="MentionModel", required=true) MentionModel mentionModel) throws Exception {
        this.init(request);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.MENTION_MODEL, (Object)mentionModel);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"ChatMentionNotificationPlugin"))).execute(ctx);
        return Response.ok(mentionModel.getMentionedUsers(), (String)"text/plain").build();
    }

    @GET
    @Path(value="/onlineUsers/")
    @RolesAllowed(value={"users"})
    public Response getOnlineUsers(@Context HttpServletRequest request) throws Exception {
        this.init(request);
        List list = this.userStateService.online().stream().map(u -> u.getUserId()).collect(Collectors.toList());
        String users = String.join((CharSequence)",", list);
        return Response.ok((Object)users, (String)"text/plain").build();
    }

    @POST
    @Path(value="getRoomParticipantsToSuggest")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get room participants to suggest", httpMethod="POST", response=Response.class, notes="This returns the list of room participants as non externals or current user connections")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found")})
    public Response getRoomParticipantsToSuggest(@Context UriInfo uriInfo, @Context HttpServletRequest request, @ApiParam(value="List of users.", required=false) List<UserBean> userList) throws Exception {
        String authenticatedUser;
        try {
            authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Identity authenticatedUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        List<Identity> currentUserConnections = Arrays.asList((Identity[])this.relationshipManager.getConnections(authenticatedUserIdentity).load(0, 0));
        ArrayList<UserBean> roomParticipantsToSuggest = new ArrayList<UserBean>();
        for (UserBean userBean : userList) {
            Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", userBean.getName());
            if (!currentUserConnections.contains(userIdentity) && (userIdentity.getProfile() == null || userIdentity.getProfile().getProperty("external") != null && !userIdentity.getProfile().getProperty("external").equals("false"))) continue;
            if (userIdentity.getProfile().getProperty("external") != null && userIdentity.getProfile().getProperty("external").equals("true")) {
                userBean.setFullname(userBean.getFullname() + " (" + this.getResourceBundleLabel(request.getLocale(), "exoplatform.chat.external") + ")");
            }
            roomParticipantsToSuggest.add(userBean);
        }
        return Response.ok(roomParticipantsToSuggest, (String)"application/json").build();
    }

    @GET
    @Path(value="/getUserState/")
    @RolesAllowed(value={"users"})
    public Response getUserState(@Context HttpServletRequest request, @QueryParam(value="user") String user) throws Exception {
        this.init(request);
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", user);
        JSONObject userStatus = new JSONObject();
        userStatus.put((Object)"isDeleted", (Object)userIdentity.isDeleted());
        userStatus.put((Object)"isEnabled", (Object)userIdentity.isEnable());
        userStatus.put((Object)"isExternal", (Object)(userIdentity.getProfile() != null && userIdentity.getProfile().getProperty("external").equals("true") ? "true" : "false"));
        return Response.ok((Object)userStatus, (String)"application/json").build();
    }

    @GET
    @Path(value="/settings")
    @RolesAllowed(value={"users"})
    public Response getUserSettings(@Context HttpServletRequest request, @Context SecurityContext sc) throws Exception {
        boolean canUploadFiles;
        this.init(request);
        String currentUsername = sc.getUserPrincipal().getName();
        String token = ServerBootstrap.getToken(currentUsername);
        Object userFullName = ServerBootstrap.getUserFullName(currentUsername);
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", currentUsername);
        boolean isExternal = userIdentity.getProfile() != null && userIdentity.getProfile().getProperty("external") != null && userIdentity.getProfile().getProperty("external").equals("true");
        Boolean isUserInitialized = (Boolean)request.getSession().getAttribute(CHAT_USER_INITIALIZATION_ATTR);
        if (isUserInitialized == null || !isUserInitialized.booleanValue()) {
            User user;
            ServerBootstrap.addUser(currentUsername, token);
            if (StringUtils.isBlank((CharSequence)userFullName) && (user = this.organizationService.getUserHandler().findUserByName(currentUsername)) != null) {
                userFullName = user.getDisplayName();
                ServerBootstrap.addUserFullNameAndEmail(currentUsername, (String)userFullName, user.getEmail());
            }
            request.getSession().setAttribute(CHAT_USER_INITIALIZATION_ATTR, (Object)true);
        }
        if (isExternal) {
            userFullName = (String)userFullName + " (" + this.getResourceBundleLabel(request.getLocale(), "exoplatform.chat.external") + ")";
        }
        boolean online = this.userStateService.isOnline(currentUsername);
        String cometdToken = this.getCometdToken();
        String isStandaloneString = PropertyManager.getProperty((String)"standaloneChatServer");
        boolean isStandalone = isStandaloneString != null && Boolean.valueOf(isStandaloneString) != false;
        String chatServerURI = ServerBootstrap.getServerURI();
        String chatPage = PropertyManager.getProperty((String)"chatPortalPage");
        Object chatCometDServerUrl = null;
        chatCometDServerUrl = isStandalone ? chatServerURI + "/cometd" : "/cometd/cometd";
        String userStatus = ServerBootstrap.getStatus(currentUsername, token, currentUsername);
        JSONObject userSettings = new JSONObject();
        userSettings.put((Object)"username", (Object)currentUsername);
        userSettings.put((Object)"token", (Object)token);
        userSettings.put((Object)"fullName", userFullName);
        userSettings.put((Object)"status", (Object)userStatus);
        userSettings.put((Object)"isOnline", (Object)online);
        userSettings.put((Object)"cometdToken", (Object)cometdToken);
        userSettings.put((Object)"sessionId", (Object)request.getSession().getId());
        userSettings.put((Object)"serverURL", (Object)ServerBootstrap.getServerURL());
        userSettings.put((Object)"standalone", (Object)isStandalone);
        userSettings.put((Object)"chatPage", (Object)chatPage);
        userSettings.put((Object)"offlineDelay", (Object)this.userStateService.getDelay());
        userSettings.put((Object)"wsEndpoint", chatCometDServerUrl);
        int uploadLimitInMB = 0;
        boolean bl = canUploadFiles = this.getDocumentService() != null;
        if (canUploadFiles) {
            uploadLimitInMB = this.getDocumentService().getUploadLimitInMB();
            userSettings.put((Object)"maxUploadSize", (Object)uploadLimitInMB);
        }
        userSettings.put((Object)"canUploadFiles", (Object)canUploadFiles);
        boolean canAddWiki = this.getWikiService() != null;
        userSettings.put((Object)"canAddWiki", (Object)canAddWiki);
        return Response.ok((Object)userSettings, (String)"application/json").build();
    }

    private void init(HttpServletRequest request) {
        ServerBootstrap.init(request);
    }

    private String getCometdToken() {
        String token;
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        Boolean standaloneChatServer = Boolean.valueOf(PropertyManager.getProperty((String)"standaloneChatServer"));
        if (standaloneChatServer.booleanValue()) {
            String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        } else {
            token = this.continuationService.getUserToken(userId);
        }
        return token;
    }

    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)CommonsUtils.getService(DocumentService.class);
        }
        return this.documentService;
    }

    public WikiService getWikiService() {
        if (this.wikiService == null) {
            this.wikiService = (WikiService)CommonsUtils.getService(WikiService.class);
        }
        return this.wikiService;
    }

    private String getResourceBundleLabel(Locale locale, String label) {
        ResourceBundleService resourceBundleService = (ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class);
        return resourceBundleService.getResourceBundle(resourceBundleService.getSharedResourceBundleNames(), locale).getString(label);
    }
}

