/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.io.IOException;

public class Literal {
    public static boolean isEscaped(char c) {
        return c >= '(' && c <= '+' || c == '?' || c == '{' || c == '}' || c == '|' || c == '$' || c == '&' || c == '^' || c == '-' || c == '.' || c == '[' || c == ']' || c == '\\';
    }

    public String getEscape(char value) {
        switch (value) {
            case '|': {
                return "\\|";
            }
            case '&': {
                return "\\&";
            }
            case '$': {
                return "\\$";
            }
            case '^': {
                return "\\^";
            }
            case '-': {
                return "\\-";
            }
            case '.': {
                return "\\.";
            }
            case '?': {
                return "\\?";
            }
            case '+': {
                return "\\+";
            }
            case '*': {
                return "\\*";
            }
            case '[': {
                return "\\[";
            }
            case ']': {
                return "\\]";
            }
            case '(': {
                return "\\(";
            }
            case ')': {
                return "\\)";
            }
            case '{': {
                return "\\{";
            }
            case '}': {
                return "\\}";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.toString(value);
    }

    public static void escapeTo(char value, Appendable appendable) throws IOException, NullPointerException {
        if (appendable == null) {
            throw new NullPointerException();
        }
        if (Literal.isEscaped(value)) {
            appendable.append('\\');
        }
        appendable.append(value);
    }
}

