/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import juzu.asset.AssetLocation;

public class Asset {
    private final String id;
    private final String type;
    private final Boolean header;
    private final AssetLocation location;
    private final String uri;
    private final String minifiedURI;
    private final Integer maxAge;

    public Asset(String id, String type, Boolean header, AssetLocation location, String uri, String minifiedURI, Integer maxAge) {
        this.id = id;
        this.type = type;
        this.location = location;
        this.uri = uri;
        this.minifiedURI = minifiedURI;
        this.maxAge = maxAge;
        this.header = header;
    }

    public Boolean getHeader() {
        return this.header;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public AssetLocation getLocation() {
        return this.location;
    }

    public String getURI() {
        return this.uri;
    }

    public String getMinifiedURI() {
        return this.minifiedURI;
    }

    public String resolveURI(boolean prod) {
        return this.minifiedURI != null && prod ? this.minifiedURI : this.uri;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public boolean isStylesheet() {
        return this.type.equals("stylesheet");
    }

    public boolean isScript() {
        return this.type.equals("script");
    }
}

