/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetResource;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Request;

public class AssetServer {
    HashMap<Application, Boolean> runtimes = new HashMap();
    private static final ThreadLocal<AssetServer> current = new ThreadLocal();

    public void register(Application assetManager, boolean cacheAssets) {
        this.runtimes.put(assetManager, cacheAssets);
    }

    public void unregister(Application assetManager) {
        this.runtimes.remove(assetManager);
    }

    public boolean doGet(String path, ServletContext ctx, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (path != null && path.length() > 0) {
            for (Map.Entry<Application, Boolean> runtime : this.runtimes.entrySet()) {
                Iterable<AssetManager> resolvers = runtime.getKey().resolveBeans(AssetManager.class);
                for (AssetManager resolver : resolvers) {
                    URL resource;
                    AssetResource content = resolver.resolveApplicationAssetResource(path);
                    if (content == null && (resource = ctx.getResource(path)) != null) {
                        content = new AssetResource(resource, null);
                    }
                    if (content == null) continue;
                    URLConnection conn = content.url.openConnection();
                    long lastModified = conn.getLastModified();
                    String etag = Tools.etag(path, lastModified);
                    Enumeration matches = req.getHeaders("If-None-Match");
                    if (matches.hasMoreElements() && ((String)matches.nextElement()).equals(etag)) {
                        resp.setStatus(304);
                    } else {
                        InputStream in = conn.getInputStream();
                        int pos = path.lastIndexOf(47);
                        String name = pos == -1 ? path : path.substring(pos + 1);
                        resp.setHeader("ETag", etag);
                        boolean cacheAssets = runtime.getValue();
                        if (cacheAssets) {
                            int maxAge;
                            int n = maxAge = content.maxAge != null ? content.maxAge : 3600;
                            if (maxAge > 0) {
                                resp.setHeader("Cache-Control", "max-age=" + maxAge);
                            }
                        } else {
                            resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                        }
                        String contentType = ctx.getMimeType(name);
                        if (contentType != null) {
                            resp.setContentType(contentType);
                        }
                        Tools.copy(in, resp.getOutputStream());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static String renderAssetURLById(String id) throws NullPointerException {
        Asset asset;
        AssetManager assetManager;
        Request request = Request.getCurrent();
        if (request != null && (assetManager = request.getApplication().resolveBean(AssetManager.class)) != null && (asset = assetManager.getAsset(id)) != null) {
            String uri = asset.resolveURI(request.getRunMode().getMinifyAssets());
            return AssetServer.renderAssetURL(request, asset.getLocation(), uri);
        }
        return null;
    }

    public static String renderAssetURLByPath(String path) throws NullPointerException {
        Request request = Request.getCurrent();
        if (request != null) {
            return AssetServer.renderAssetURL(request, AssetLocation.APPLICATION, path);
        }
        return null;
    }

    public static String renderAssetURLByPath(AssetLocation location, String path) throws NullPointerException {
        Request request = Request.getCurrent();
        if (request != null) {
            return AssetServer.renderAssetURL(request, location, path);
        }
        return null;
    }

    private static String renderAssetURL(Request request, AssetLocation location, String uri) throws NullPointerException {
        StringBuilder buffer = new StringBuilder();
        switch (location) {
            case APPLICATION: {
                request.renderAssetURL(location, uri, buffer);
                break;
            }
            default: {
                request.renderAssetURL(location, uri, buffer);
            }
        }
        return buffer.toString();
    }
}

