/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi.provided;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import juzu.Handler;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.cdi.CDIContext;
import juzu.impl.inject.spi.cdi.CDIInjector;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.resource.ResourceResolver;

public class ProvidedCDIInjector
extends CDIInjector {
    private static final Map<ClassLoader, ProvidedCDIInjector> REGISTRY = Collections.synchronizedMap(new IdentityHashMap());
    private final ClassLoader classLoader;
    private final BeanManager beanManager;
    private final ResourceResolver resolver;
    private final Application application;

    public static CDIInjector get(ClassLoader loader) {
        return REGISTRY.get(loader);
    }

    public ProvidedCDIInjector(ClassLoader classLoader, BeanManager beanManager, ApplicationDescriptor descriptor, ResourceResolver resolver) {
        REGISTRY.put(Thread.currentThread().getContextClassLoader(), this);
        Application application = new Application(this, descriptor, resolver);
        this.classLoader = classLoader;
        this.beanManager = beanManager;
        this.resolver = resolver;
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    @Override
    public boolean isProvided() {
        return true;
    }

    @Override
    public <P> Injector addFileSystem(ReadFileSystem<P> fs) {
        return this;
    }

    @Override
    public Injector setClassLoader(ClassLoader classLoader) {
        return this;
    }

    @Override
    public InjectionContext<?, ?> create(Handler<Class<?>, Boolean> filter) throws Exception {
        return new CDIContext(this, filter){

            @Override
            public ClassLoader getClassLoader() {
                return ProvidedCDIInjector.this.classLoader;
            }

            @Override
            public BeanManager getBeanManager() {
                return ProvidedCDIInjector.this.beanManager;
            }

            @Override
            public InjectorProvider getProvider() {
                return InjectorProvider.CDI;
            }
        };
    }

    @Override
    public Injector get() {
        return this;
    }
}

