/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Completion;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelPlugin;
import juzu.impl.metamodel.MetaModelState;

public abstract class MetaModelProcessor<P extends MetaModelPlugin<M, P>, M extends MetaModel<P, M>>
extends BaseProcessor {
    public static final MessageCode ANNOTATION_UNSUPPORTED = new MessageCode("ANNOTATION_UNSUPPORTED", "The annotation of this element cannot be supported");
    private MetaModelState<P, M> state;
    private int index;
    private final Logger log = BaseProcessor.getLogger(this.getClass());
    private HashSet<String> supportedAnnotations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInit(ProcessingContext context) {
        this.log.info("Using processing env " + context.getClass().getName());
        if (this.state == null) {
            InputStream in = null;
            try {
                FileObject file = this.getContext().getResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", (CharSequence)"metamodel.ser");
                in = file.openInputStream();
                ObjectInputStream ois = new ObjectInputStream(in);
                this.state = (MetaModelState)ois.readObject();
                this.log.info("Loaded model from " + file.toUri());
            }
            catch (Exception e) {
                try {
                    this.log.info("Created new meta model");
                    MetaModelState<P, M> metaModel = new MetaModelState<P, M>(this.getPluginType(), this.createMetaModel());
                    metaModel.init(this.getContext());
                    this.state = metaModel;
                }
                catch (Throwable throwable) {
                    Tools.safeClose(in);
                    throw throwable;
                }
                Tools.safeClose(in);
            }
            Tools.safeClose(in);
        }
        HashSet<String> supportedAnnotations = new HashSet<String>();
        for (Class<Annotation> supportedAnnotation : this.state.context.getSupportedAnnotations()) {
            supportedAnnotations.add(supportedAnnotation.getName());
        }
        this.supportedAnnotations = supportedAnnotations;
        this.index = 0;
    }

    protected abstract Class<P> getPluginType();

    protected abstract M createMetaModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.errorRaised()) {
            if (roundEnv.processingOver()) {
                this.log.info("APT processing over");
                this.log.info("Passivating model");
                ((MetaModel)this.state.metaModel).prePassivate();
                ObjectOutputStream out = null;
                try {
                    FileObject file = this.getContext().createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", (CharSequence)"metamodel.ser", new Element[0]);
                    out = new ObjectOutputStream(file.openOutputStream());
                    out.writeObject(this.state);
                    this.state = null;
                    Tools.safeClose(out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.info("Could not passivate model ", e);
                }
                finally {
                    Tools.safeClose(out);
                }
            } else {
                this.log.info("Starting APT round #" + this.index);
                if (this.index == 0) {
                    this.log.info("Activating model");
                    ((MetaModel)this.state.metaModel).postActivate(this.getContext());
                }
                LinkedHashMap<AnnotationKey, AnnotationState> updates = new LinkedHashMap<AnnotationKey, AnnotationState>();
                for (TypeElement typeElement : annotations) {
                    if (!this.supportedAnnotations.contains(typeElement.getQualifiedName().toString())) continue;
                    this.log.info("Processing elements for annotation for " + typeElement.getQualifiedName());
                    for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                        if (element.getAnnotation(Generated.class) != null) continue;
                        this.log.info("Processing element " + element);
                        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                            if (!annotationMirror.getAnnotationType().asElement().equals(typeElement)) continue;
                            AnnotationKey key = new AnnotationKey(element, annotationMirror);
                            AnnotationState state = AnnotationState.create(annotationMirror);
                            updates.put(key, state);
                        }
                    }
                }
                this.log.info("Process annotations");
                this.state.context.processAnnotations(updates.entrySet());
                this.log.info("Post processing model");
                ((MetaModel)this.state.metaModel).postProcessAnnotations();
                this.log.info("Process events");
                ((MetaModel)this.state.metaModel).processEvents();
                this.log.info("Post process events");
                ((MetaModel)this.state.metaModel).postProcessEvents();
                this.log.info("Ending APT round #" + this.index++);
            }
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        Iterable<Object> completions;
        if (element != null) {
            this.log.info("Activating model");
            ((MetaModel)this.state.metaModel).postActivate(this.getContext());
            AnnotationKey annotationKey = new AnnotationKey(element, Name.parse(((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().toString()));
            AnnotationState annotationState = AnnotationState.create(annotation);
            completions = this.state.context.getCompletions(annotationKey, annotationState, member.getSimpleName().toString(), userText);
        } else {
            completions = Collections.emptyList();
        }
        return completions != null ? completions : Collections.emptyList();
    }
}

