/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import juzu.impl.common.Tools;
import juzu.impl.io.AppendableStream;
import juzu.impl.io.BinaryOutputStream;
import juzu.impl.io.SinkStream;
import juzu.io.Chunk;
import juzu.io.Stream;

public abstract class OutputStream
implements Stream,
Closeable {
    public static final int BUFFER_SIZE = 512;
    private LinkedList<Error> errors = null;

    public static OutputStream create(Charset charset, Appendable out) {
        return new AppendableStream(charset, out);
    }

    public static OutputStream create(Charset charset, Appendable out, Flushable flushable, Closeable closeable) {
        return new AppendableStream(charset, out, flushable, closeable);
    }

    public static OutputStream create(Charset charset, java.io.OutputStream out) {
        return new BinaryOutputStream(charset, out);
    }

    public static SinkStream create() {
        return SinkStream.INSTANCE;
    }

    @Override
    public void provide(Chunk chunk) {
        block10: {
            try {
                if (!(chunk instanceof Chunk.Data)) break block10;
                Chunk.Data data = (Chunk.Data)chunk;
                if (data instanceof Chunk.Data.Bytes) {
                    this.append(((Chunk.Data.Bytes)data).data);
                    break block10;
                }
                if (data instanceof Chunk.Data.Chars) {
                    this.append(CharBuffer.wrap(((Chunk.Data.Chars)data).data));
                    break block10;
                }
                if (data instanceof Chunk.Data.CharSequence) {
                    Chunk.Data.CharSequence cs = (Chunk.Data.CharSequence)data;
                    this.append(cs.data, cs.start, cs.end);
                    break block10;
                }
                if (data instanceof Chunk.Data.Char) {
                    Chunk.Data.Char cs = (Chunk.Data.Char)data;
                    this.append(cs.value);
                    break block10;
                }
                if (data instanceof Chunk.Data.InputStream) {
                    ByteArrayOutputStream baos = Tools.copy(((Chunk.Data.InputStream)data).data, new ByteArrayOutputStream());
                    this.append(baos.toByteArray());
                    break block10;
                }
                if (data instanceof Chunk.Data.Readable) {
                    Readable readable = ((Chunk.Data.Readable)data).data;
                    CharBuffer buffer = CharBuffer.allocate(512);
                    int i = readable.read(buffer);
                    while (i != -1) {
                        buffer.flip();
                        this.append(buffer);
                        buffer.clear();
                        i = readable.read(buffer);
                    }
                    if (readable instanceof Closeable) {
                        Tools.safeClose((Closeable)((Object)readable));
                    }
                    break block10;
                }
                throw new IOException("Not yet handled");
            }
            catch (IOException e) {
                this.reportError(e);
            }
        }
    }

    @Override
    public void close(Thread.UncaughtExceptionHandler errorHandler) {
        try {
            this.close();
        }
        catch (Exception e) {
            this.reportError(e);
        }
        if (errorHandler != null && this.errors != null) {
            for (Error error : this.errors) {
                errorHandler.uncaughtException(error.thread, error.uncaught);
            }
        }
    }

    private void reportError(Throwable t) {
        if (this.errors == null) {
            this.errors = new LinkedList();
        }
        this.errors.add(new Error(Thread.currentThread(), t));
    }

    public abstract void append(CharBuffer var1) throws IOException;

    public abstract void append(CharSequence var1) throws IOException;

    public abstract void append(CharSequence var1, int var2, int var3) throws IOException;

    public abstract void append(ByteBuffer var1) throws IOException;

    public abstract void append(char var1) throws IOException;

    public abstract void append(byte[] var1) throws IOException;

    public abstract void append(byte[] var1, int var2, int var3) throws IOException;

    private static class Error {
        final Thread thread;
        final Throwable uncaught;

        private Error(Thread thread, Throwable uncaught) {
            this.thread = thread;
            this.uncaught = uncaught;
        }
    }
}

