/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.upgrade;

import java.util.Arrays;
import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChatSpacesAdministratorsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getExoLogger(ChatSpacesAdministratorsUpgradePlugin.class);
    private SpaceService spaceService;
    private ContinuationService continuationService;
    private String superUser;
    private String superUserChatToken;
    private int LIMIT = 100;

    public ChatSpacesAdministratorsUpgradePlugin(InitParams initParams, SpaceService spaceService, UserACL userACL, ContinuationService continuationService) {
        super(initParams);
        this.spaceService = spaceService;
        this.continuationService = continuationService;
        this.superUser = userACL.getSuperUser();
        this.superUserChatToken = ServerBootstrap.getToken(this.superUser);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        log.info((Object)"Start Remove Space administrator from all space chat room");
        boolean chatServerStarted = false;
        int nbTest = 0;
        while (!chatServerStarted && nbTest < 100) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.debug("Test if chatServer is running ({} times)", new Object[]{++nbTest});
            ServerBootstrap.addUser(this.superUser, this.superUserChatToken);
            String result = ServerBootstrap.getStatus(this.superUser, this.superUserChatToken, this.superUser);
            if (result == null) continue;
            chatServerStarted = true;
        }
        if (!chatServerStarted) {
            throw new RuntimeException("Unable to join chatServer");
        }
        try {
            ListAccess allSpaces = this.spaceService.getAllSpacesByFilter(new SpaceFilter());
            int current = 0;
            do {
                Space[] spaces = (Space[])allSpaces.load(current, this.LIMIT);
                Arrays.stream(spaces).forEach(space -> this.checkSpace((Space)space));
                log.info("Run upgrade on {}/{} spaces", new Object[]{current += spaces.length, allSpaces.getSize()});
            } while (current < allSpaces.getSize());
        }
        catch (Exception e) {
            log.error((Object)"Unable to treat all spaces", (Throwable)e);
            throw new RuntimeException(e);
        }
        log.info("End Remove Space administrator from all space chat room, execution time={}ms", new Object[]{System.currentTimeMillis() - startupTime});
    }

    private void checkSpace(Space space) {
        JSONObject jsonCountUsers;
        String spaceRoomId;
        String userCountInSpace;
        JSONObject jsonSpace;
        String spaceString = ServerBootstrap.getSpaceRoom(this.superUser, this.superUserChatToken, space.getId());
        log.debug("Check space {}, result={}", new Object[]{space.getPrettyName(), spaceString});
        if (spaceString != null && (jsonSpace = new JSONObject(spaceString)).has("user") && (userCountInSpace = ServerBootstrap.getUserCount(this.superUser, this.superUserChatToken, spaceRoomId = jsonSpace.getString("user"))) != null && (jsonCountUsers = new JSONObject(userCountInSpace)).has("usersCount")) {
            int spaceUserCount = jsonCountUsers.getInt("usersCount");
            log.debug("Space Room with name {} and id {} has {} users", new Object[]{spaceRoomId, space.getPrettyName(), spaceUserCount});
            String usersInSpaceRoom = ServerBootstrap.getUsersWithLimit(this.superUser, this.superUserChatToken, spaceRoomId, spaceUserCount);
            JSONObject users = new JSONObject(usersInSpaceRoom);
            if (users.has("users")) {
                this.checkUsers(users.getJSONArray("users"), space);
                if (spaceUserCount != users.getJSONArray("users").length()) {
                    this.checkUser(space, this.superUser);
                }
            }
        }
    }

    private void checkUsers(JSONArray users, Space space) {
        for (int i = 0; i < users.length(); ++i) {
            JSONObject user = users.getJSONObject(i);
            String username = user.getString("name");
            this.checkUser(space, username);
        }
    }

    private void checkUser(Space space, String username) {
        if (!this.spaceService.isMember(space, username)) {
            log.debug("User {} is member of space room, but not member of space {}, remove it from the space room", new Object[]{username, space.getPrettyName()});
            ServerBootstrap.removeUserFromSpace(username, space.getId());
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }
}

