/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.upgrade;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.services.SettingDataStorage;
import org.exoplatform.chat.services.mongodb.MongoBootstrap;
import org.exoplatform.chat.utils.ChatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="favoritesMigrationService")
@ApplicationScoped
@Singleton
public class FavoritesMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(FavoritesMigrationService.class);
    private static final String SETTING_MIGRATION_STATUS = "upgrade-favorites";
    @Inject
    private SettingDataStorage settingDataStorage;

    public void processMigration() {
        MongoBootstrap mongoBootstrap = ConnectionManager.getInstance();
        DB db = mongoBootstrap.getDB();
        FavoritesMigrationStatus migrationStatus = this.getMigrationStatus(db.getName());
        if (migrationStatus == null) {
            this.setMigrationStatus(FavoritesMigrationStatus.RUNNING, db.getName());
            LOG.info("== Chat users favorites migration starting ==");
            DBCollection usersCol = db.getCollection("users");
            long totalNbOfUsers = usersCol.count();
            LOG.info("  Chat users favorites migration - Nb of users to migrate : " + totalNbOfUsers);
            DBCursor usersCursor = usersCol.find();
            int nbOfUsersProcessed = 0;
            while (usersCursor.hasNext()) {
                DBObject user = usersCursor.next();
                try {
                    this.migrateUserFavorites(usersCol, user);
                }
                catch (Exception e) {
                    LOG.error("Error while migrating Chat favorites of user " + user.get("user") + " : " + e.getMessage(), (Throwable)e);
                }
                if (++nbOfUsersProcessed % 100 != 0 && (long)nbOfUsersProcessed != totalNbOfUsers) continue;
                LOG.info("  Chat users favorites migration - Progress : " + nbOfUsersProcessed + "/" + totalNbOfUsers);
            }
            this.setMigrationStatus(FavoritesMigrationStatus.DONE, db.getName());
            LOG.info("== Chat users favorites migration done ==");
        }
    }

    public FavoritesMigrationStatus getMigrationStatus(String dbName) {
        String status = this.settingDataStorage.getSetting(SETTING_MIGRATION_STATUS, dbName);
        if (status != null) {
            return FavoritesMigrationStatus.valueOf(status);
        }
        return null;
    }

    public void setMigrationStatus(FavoritesMigrationStatus status, String dbName) {
        this.settingDataStorage.setSetting(SETTING_MIGRATION_STATUS, status.toString(), dbName);
    }

    private void migrateUserFavorites(DBCollection usersCol, DBObject user) throws Exception {
        List favorites;
        if (user != null && (favorites = (List)user.get("favorites")) != null) {
            List newFavorites = favorites.stream().filter(Objects::nonNull).map(oldFavorite -> {
                if (oldFavorite.startsWith("team-")) {
                    return oldFavorite.substring("team-".length());
                }
                if (oldFavorite.startsWith("space-")) {
                    return oldFavorite.substring("space-".length());
                }
                return ChatUtils.getRoomId(Arrays.asList((String)user.get("user"), oldFavorite));
            }).collect(Collectors.toList());
            BasicDBObject searchQuery = new BasicDBObject("_id", user.get("_id"));
            BasicDBObject updateQuery = new BasicDBObject();
            updateQuery.append("$set", (Object)new BasicDBObject().append("favorites", newFavorites));
            usersCol.update((DBObject)searchQuery, (DBObject)updateQuery);
        }
    }

    static enum FavoritesMigrationStatus {
        RUNNING,
        DONE;

    }
}

