/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.ChatDataStorage;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.PropertyManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Named(value="chatService")
@ApplicationScoped
@Singleton
public class ChatServiceImpl
implements ChatService {
    private static final Logger LOG = Logger.getLogger("ChatService");
    @Inject
    private ChatDataStorage chatStorage;
    @Inject
    private UserService userService;
    @Inject
    private NotificationService notificationService;
    @Inject
    private RealTimeMessageService realTimeMessageService;

    public void write(String message, String user, String room, String isSystem) {
        this.write(null, message, user, room, isSystem, null);
    }

    public void write(String clientId, String message, String sender, String room, String isSystem, String options) {
        if (!this.isMemberOfRoom(sender, room)) {
            throw new ChatException(403, "Petit malin !");
        }
        if (isSystem == null) {
            isSystem = "false";
        }
        String msgId = this.chatStorage.save(message, sender, room, isSystem, options);
        RoomBean roomBean = this.userService.getRoom(sender, room);
        String roomType = roomBean.getType();
        if (!"e".equals(roomType)) {
            ArrayList<String> usersToBeNotified = null;
            if ("u".equals(roomType)) {
                usersToBeNotified = new ArrayList<String>();
                usersToBeNotified.add(roomBean.getUser());
            } else {
                usersToBeNotified = this.userService.getUsersFilterBy(sender, room, roomType);
            }
            MessageBean msg = this.chatStorage.getMessage(room, msgId);
            UserBean user = this.userService.getUser(sender);
            msg.setFullName(user.getFullname());
            JSONObject data = msg.toJSONObject();
            data.put((Object)"clientId", (Object)clientId);
            data.put((Object)"roomType", (Object)roomType);
            data.put((Object)"room", (Object)room);
            if ("u".equals(roomType)) {
                data.put((Object)"roomDisplayName", (Object)user.getFullname());
            } else {
                data.put((Object)"roomDisplayName", (Object)roomBean.getFullName());
            }
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_READ, room, user.getName(), new Date(), (Map)data);
            this.realTimeMessageService.sendMessage(messageBean, sender);
            messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_SENT, room, user.getName(), new Date(), (Map)data);
            this.realTimeMessageService.sendMessage(messageBean, usersToBeNotified);
            String intranetPage = PropertyManager.getProperty((String)"chatPortalPage");
            String content = message.length() > 30 ? message.substring(0, 29) + "..." : message;
            for (String receiver : usersToBeNotified) {
                if (StringUtils.equals((CharSequence)receiver, (CharSequence)sender)) continue;
                this.notificationService.addNotification(receiver, sender, "chat", "room", room, content, intranetPage + "?room=" + room, options);
            }
            this.notificationService.setNotificationsAsRead(sender, "chat", "room", room);
        }
    }

    public String save(String message, String user, String room, String isSystem, String options) {
        return this.chatStorage.save(message, user, room, isSystem, options);
    }

    public void delete(String room, String sender, String messageId) {
        this.chatStorage.delete(room, sender, messageId);
        String roomType = this.getTypeRoomChat(room);
        if (!roomType.equals("e")) {
            HashSet<String> usersToBeNotified = new HashSet<String>();
            if (roomType.equals("s")) {
                usersToBeNotified = new HashSet(this.userService.getUsersFilterBy(sender, room, "s"));
            } else if (roomType.equals("t")) {
                usersToBeNotified = new HashSet(this.userService.getUsersFilterBy(sender, room, "t"));
            } else {
                UserBean userBean = this.userService.getUser(room);
                String username = userBean.getName();
                if (username == null) {
                    List users = this.userService.getUsersInRoomChatOneToOne(room);
                    for (UserBean targetUserBean : users) {
                        usersToBeNotified.add(targetUserBean.getName());
                    }
                }
            }
            usersToBeNotified.add(sender);
            MessageBean msg = this.chatStorage.getMessage(room, messageId);
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_DELETED, room, sender, new Date(), (Map)msg.toJSONObject());
            this.realTimeMessageService.sendMessage(messageBean, new ArrayList<String>(usersToBeNotified));
        }
    }

    public RoomBean getTeamRoomById(String roomId) {
        return this.chatStorage.getTeamRoomById(roomId);
    }

    public List<RoomBean> getTeamRoomsByName(String teamName) {
        return this.chatStorage.getTeamRoomByName(teamName);
    }

    public void deleteTeamRoom(String room, String user) {
        List usersToBeNotified = this.userService.getUsersFilterBy(user, room, "t");
        this.chatStorage.deleteTeamRoom(room, user);
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_DELETED, room, user, new Date(), null);
        this.realTimeMessageService.sendMessage(messageBean, user);
        this.realTimeMessageService.sendMessage(messageBean, usersToBeNotified);
    }

    public void edit(String room, String sender, String messageId, String message) {
        this.chatStorage.edit(room, sender, messageId, message);
        RoomBean roomBean = this.userService.getRoom(sender, room);
        String roomType = roomBean.getType();
        if (!"e".equals(roomType)) {
            ArrayList<String> usersToBeNotified = new ArrayList<String>();
            if ("u".equals(roomType)) {
                usersToBeNotified.add(roomBean.getUser());
            } else {
                usersToBeNotified = this.userService.getUsersFilterBy(sender, room, roomType);
            }
            MessageBean msg = this.chatStorage.getMessage(room, messageId);
            UserBean user = this.userService.getUser(sender);
            msg.setFullName(user.getFullname());
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_UPDATED, room, sender, new Date(), (Map)msg.toJSONObject());
            this.realTimeMessageService.sendMessage(messageBean, sender);
            this.realTimeMessageService.sendMessage(messageBean, usersToBeNotified);
        }
    }

    public String read(String user, String room) {
        return this.read(user, room, false, null, null, 0);
    }

    public String read(String user, String room, boolean isTextOnly, Long fromTimestamp) {
        return this.read(user, room, isTextOnly, fromTimestamp, null, 0);
    }

    public String read(String user, String room, boolean isTextOnly, Long fromTimestamp, Long toTimestamp, int limit) {
        if (!this.isMemberOfRoom(user, room)) {
            throw new ChatException(403, "Petit malin !");
        }
        return this.chatStorage.read(room, isTextOnly, fromTimestamp, toTimestamp, limit);
    }

    public MessageBean getMessage(String roomId, String messageId) {
        return this.chatStorage.getMessage(roomId, messageId);
    }

    public String getSpaceRoom(String space) {
        return this.chatStorage.getSpaceRoom(space);
    }

    public String getSpaceRoomByName(String name) {
        return this.chatStorage.getSpaceRoomByName(name);
    }

    public String getTeamRoom(String team, String user) {
        return this.chatStorage.getTeamRoom(team, user);
    }

    public String getExternalRoom(String identifier) {
        return this.chatStorage.getExternalRoom(identifier);
    }

    public String getTeamCreator(String room) {
        return this.chatStorage.getTeamCreator(room);
    }

    public void setRoomName(String room, String name) {
        this.chatStorage.setRoomName(room, name);
        List users = this.userService.getUsersFilterBy(null, room, "t");
        JSONObject data = new JSONObject();
        data.put((Object)"title", (Object)name);
        JSONArray array = new JSONArray();
        array.addAll((Collection)users);
        data.put((Object)"members", (Object)array);
        RealTimeMessageBean updatedRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_UPDATED, room, null, null, (Map)data);
        for (String u : users) {
            this.realTimeMessageService.sendMessage(updatedRoomMessage, u);
        }
    }

    public void setRoomMeetingStatus(String room, boolean start, String startTime) {
        this.chatStorage.setRoomMeetingStatus(room, start, startTime);
    }

    public String getRoom(List<String> users) {
        return this.chatStorage.getRoom(users);
    }

    public String getTypeRoomChat(String roomId) {
        return this.chatStorage.getTypeRoomChat(roomId);
    }

    public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService) {
        return this.chatStorage.getExistingRooms(user, withPublic, isAdmin, notificationService, tokenService);
    }

    public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, NotificationService notificationService, TokenService tokenService) {
        return this.getRooms(user, new ArrayList<String>(), filter, withUsers, withSpaces, withPublic, withOffline, isAdmin, 0, notificationService, tokenService);
    }

    public RoomsBean getRooms(String user, List<String> onlineUsers, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, int limit, NotificationService notificationService, TokenService tokenService) {
        return this.chatStorage.getRooms(user, onlineUsers, filter, withUsers, withSpaces, withPublic, withOffline, isAdmin, limit, notificationService, tokenService);
    }

    public int getNumberOfRooms() {
        return this.chatStorage.getNumberOfRooms();
    }

    public int getNumberOfMessages() {
        return this.chatStorage.getNumberOfMessages();
    }

    private boolean isMemberOfRoom(String username, String roomId) {
        List<String> roomMembers;
        RoomBean room = this.userService.getRoom(username, roomId);
        if (room == null) {
            LOG.warning("Cannot check if user " + username + " is member of room " + roomId + " since the room does not exist.");
            return false;
        }
        if (room.getType().equals("t")) {
            roomMembers = this.userService.getUsersFilterBy(null, roomId, "t");
        } else if (room.getType().equals("s")) {
            roomMembers = this.userService.getUsersFilterBy(null, roomId, "s");
        } else {
            roomMembers = new ArrayList();
            List userBeans = this.userService.getUsersInRoomChatOneToOne(roomId);
            if (userBeans != null) {
                for (UserBean userBean : userBeans) {
                    roomMembers.add(userBean.getName());
                }
            }
        }
        return roomMembers != null && roomMembers.contains(username);
    }
}

