/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.cometd.annotation.server.AnnotationCometDServlet;
import org.cometd.annotation.server.ServerAnnotationProcessor;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.client.http.jetty.JettyHttpClientTransport;
import org.cometd.client.websocket.javax.WebSocketTransport;
import org.cometd.oort.Oort;
import org.cometd.oort.OortConfigServlet;
import org.cometd.oort.OortMulticastConfigServlet;
import org.cometd.oort.OortStaticConfigServlet;
import org.cometd.oort.Seti;
import org.cometd.oort.SetiServlet;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.client.HttpClient;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.server.EXoContinuationBayeux;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ServletContextWrapper;

public class CometdConfigurationServlet
extends AnnotationCometDServlet {
    private static final Log LOG = ExoLogger.getExoLogger(CometdConfigurationServlet.class);
    private OortConfigServlet oConfig;
    private SetiServlet setiConfig;
    private boolean standalone;
    private boolean clusterEnabled = false;
    public static final String PREFIX = "exo.cometd.";
    protected static final String CLOUD_ID_SEPARATOR = "exo.cometd.cloudIDSeparator";
    public static String OORT_CONFIG_TYPE = "exo.cometd.oort.configType";
    public static String OORT_STATIC = "static";
    public static final Pattern URL_REGEX;

    public void init(ServletConfig config) throws ServletException {
        super.init((ServletConfig)new ServletConfigWrapper(config));
    }

    public void init() throws ServletException {
        this.standalone = Boolean.valueOf(org.exoplatform.chat.utils.PropertyManager.getProperty((String)"standaloneChatServer"));
        if (this.standalone) {
            LOG.debug((Object)"Chat mode detected : 2 servers");
            this.lazyInit();
        } else {
            LOG.debug((Object)"Chat mode detected : 1 server");
            RootContainer.getInstance().addInitTask(this.getServletContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

                public void execute(ServletContext servletContext, PortalContainer portalContainer) {
                    CometdConfigurationServlet.this.lazyInit();
                }
            }, PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME);
        }
    }

    private void lazyInit() {
        try {
            super.init();
            if (this.standalone) {
                String configType;
                String profiles = PropertyManager.getProperty((String)"exo.profiles");
                if (profiles != null) {
                    this.clusterEnabled = profiles.contains("cluster");
                    if (this.clusterEnabled) {
                        this.warnInvalidUrl(this.getInitParameter("oort.url"));
                    }
                }
                this.oConfig = OORT_STATIC.equals(configType = this.getInitParameter(OORT_CONFIG_TYPE)) ? new OortStaticConfig() : new OortMulticastConfig();
                ServletConfig servletConfig = this.getServletConfig();
                this.oConfig.init(servletConfig);
                this.setiConfig = new SetiServlet();
                this.setiConfig.init(servletConfig);
                ServletContext cometdContext = servletConfig.getServletContext();
                Seti seti = (Seti)cometdContext.getAttribute(Seti.SETI_ATTRIBUTE);
                Oort oort = (Oort)cometdContext.getAttribute(Oort.OORT_ATTRIBUTE);
                EXoContinuationBayeux bayeux = (EXoContinuationBayeux)this.getBayeux();
                bayeux.setSeti(seti);
                bayeux.setOort(oort);
                String separator = this.getInitParameter(CLOUD_ID_SEPARATOR);
                if (separator != null) {
                    bayeux.setCloudIDSeparator(separator);
                }
            }
            RealTimeMessageService realTimeMessageService = (RealTimeMessageService)GuiceManager.getInstance().getInstance(RealTimeMessageService.class);
            realTimeMessageService.setBayeux((BayeuxServer)this.getBayeux());
        }
        catch (ServletException e) {
            LOG.error((Object)"Cannot initialize Bayeux", (Throwable)e);
        }
    }

    protected BayeuxServerImpl newBayeuxServer() {
        if (this.standalone) {
            return new EXoContinuationBayeux((TokenService)GuiceManager.getInstance().getInstance(TokenService.class));
        }
        return (BayeuxServerImpl)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(org.mortbay.cometd.continuation.EXoContinuationBayeux.class);
    }

    protected ServerAnnotationProcessor newServerAnnotationProcessor(BayeuxServer bayeuxServer) {
        return new ServerAnnotationProcessor(bayeuxServer);
    }

    private void warnInvalidUrl(String url) {
        if (url == null || url.isEmpty()) {
            LOG.warn((Object)"You didn\u2019t set exo.cometd.oort.url, cometd cannot work in cluster mode without this property, please set it.");
        } else if (!URL_REGEX.matcher(url).matches()) {
            LOG.warn("exo.cometd.oort.url is invalid {}, cometd cannot work in cluster mode without this property, please set it.", new Object[]{url});
        }
    }

    private Oort configTransports(Oort oort) {
        ServletConfig config = this.getServletConfig();
        String transport = config.getInitParameter("transports");
        if (transport == null || !transport.contains(WebSocketTransport.class.getName())) {
            oort.getClientTransportFactories().add(new JettyHttpClientTransport.Factory(new HttpClient()));
        }
        return oort;
    }

    static {
        String ip_regex = "(((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)";
        URL_REGEX = Pattern.compile("^((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?(" + ip_regex + "|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$");
    }

    private class ServletConfigWrapper
    implements ServletConfig {
        private ServletConfig delegate;
        private ServletContext contextWrapper;
        private String[] configs;

        public ServletConfigWrapper(ServletConfig config) {
            this.delegate = config;
            this.contextWrapper = new ServletContextWrapper(this.delegate.getServletContext());
        }

        public String getInitParameter(String name) {
            String value = PropertyManager.getProperty((String)(CometdConfigurationServlet.PREFIX + name));
            if (value == null) {
                value = this.delegate.getInitParameter(name);
            }
            return value;
        }

        public Enumeration<String> getInitParameterNames() {
            if (this.configs == null) {
                LinkedList<String> keys = new LinkedList<String>();
                Properties props = PrivilegedSystemHelper.getProperties();
                int len = CometdConfigurationServlet.PREFIX.length();
                for (Object key : props.keySet()) {
                    String k = key.toString().trim();
                    if (!k.startsWith(CometdConfigurationServlet.PREFIX) || k.length() <= len) continue;
                    keys.add(k.substring(len));
                }
                this.configs = keys.toArray(new String[keys.size()]);
            }
            HashSet<Object> names = new HashSet<Object>();
            names.addAll(Collections.list(this.delegate.getInitParameterNames()));
            names.addAll(Arrays.asList(this.configs));
            return Collections.enumeration(names);
        }

        public ServletContext getServletContext() {
            return this.contextWrapper;
        }

        public String getServletName() {
            return this.delegate.getServletName();
        }
    }

    public class OortStaticConfig
    extends OortStaticConfigServlet {
        private static final long serialVersionUID = 1054209695244836363L;

        protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
            if (CometdConfigurationServlet.this.clusterEnabled) {
                super.configureCloud(config, oort);
            }
        }

        protected Oort newOort(BayeuxServer bayeux, String url) {
            Oort oort = super.newOort(bayeux, url);
            return CometdConfigurationServlet.this.configTransports(oort);
        }
    }

    public class OortMulticastConfig
    extends OortMulticastConfigServlet {
        private static final long serialVersionUID = 6836833932474627776L;

        protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
            if (CometdConfigurationServlet.this.clusterEnabled) {
                super.configureCloud(config, oort);
            }
        }

        protected Oort newOort(BayeuxServer bayeux, String url) {
            Oort oort = super.newOort(bayeux, url);
            return CometdConfigurationServlet.this.configTransports(oort);
        }
    }
}

