/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.model;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.ReportBean;
import org.exoplatform.chat.model.UserBean;
import org.junit.Assert;
import org.junit.Test;

public class ReportBeanTest {
    public static ResourceBundle getResourceBundle() {
        return new ListResourceBundle(){
            private Object[][] contents = new Object[][]{{"exoplatform.chat.meetingnotes.task", "Task {0} assigned to {1} - Due date : {2}"}};

            @Override
            protected Object[][] getContents() {
                return this.contents;
            }
        };
    }

    @Test
    public void shouldReportTaskWithAllFields() {
        ReportBean reportBean = new ReportBean(ReportBeanTest.getResourceBundle());
        BasicDBList messages = new BasicDBList();
        long now = Instant.now().getEpochSecond();
        String tomorrow = Instant.now().plus(1L, ChronoUnit.DAYS).toString();
        BasicDBObject options = new BasicDBObject().append("type", (Object)"type-task").append("task", (Object)"Task 1").append("username", (Object)"john").append("dueDate", (Object)tomorrow);
        BasicDBObject message = new BasicDBObject().append("msg", (Object)"Message test").append("timestamp", (Object)now).append("user", (Object)"john").append("fullname", (Object)"John Smith").append("options", (Object)options).append("isSystem", (Object)"true");
        messages.add((Object)message);
        reportBean.fill(messages, Arrays.asList(new UserBean()));
        List reportMessages = reportBean.getMessages();
        Assert.assertNotNull((Object)reportMessages);
        Assert.assertEquals((long)1L, (long)reportMessages.size());
        MessageBean messageBean = (MessageBean)reportMessages.get(0);
        Assert.assertEquals((Object)"john", (Object)messageBean.getUser());
        Assert.assertEquals((long)now, (long)messageBean.getTimestamp());
        Assert.assertEquals((Object)("[ Task Task 1 assigned to john - Due date : " + tomorrow + " ]"), (Object)messageBean.getMessage());
    }

    @Test
    public void shouldReportTaskWhenDoesNotContainAllFields() {
        ReportBean reportBean = new ReportBean(ReportBeanTest.getResourceBundle());
        BasicDBList messages = new BasicDBList();
        long now = Instant.now().getEpochSecond();
        BasicDBObject options = new BasicDBObject().append("type", (Object)"type-task").append("task", (Object)"Task 1");
        BasicDBObject message = new BasicDBObject().append("msg", (Object)"Message test").append("timestamp", (Object)now).append("user", (Object)"john").append("fullname", (Object)"John Smith").append("options", (Object)options).append("isSystem", (Object)"true");
        messages.add((Object)message);
        reportBean.fill(messages, Arrays.asList(new UserBean()));
        List reportMessages = reportBean.getMessages();
        Assert.assertNotNull((Object)reportMessages);
        Assert.assertEquals((long)1L, (long)reportMessages.size());
        MessageBean messageBean = (MessageBean)reportMessages.get(0);
        Assert.assertEquals((Object)"john", (Object)messageBean.getUser());
        Assert.assertEquals((long)now, (long)messageBean.getTimestamp());
        Assert.assertEquals((Object)"[ Task Task 1 assigned to  - Due date :  ]", (Object)messageBean.getMessage());
    }
}

