/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.upgrade;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.Arrays;
import java.util.List;
import org.bson.conversions.Bson;
import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.services.mongodb.MongoBootstrap;
import org.exoplatform.chat.services.upgrade.FavoritesMigrationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FavoritesMigrationServiceTest
extends AbstractChatTestCase {
    private MongoDatabase db;
    private UserService userService;
    private ChatService chatService;
    private FavoritesMigrationService favoritesMigrationService;

    @Before
    public void setUp() {
        this.db = ConnectionManager.getInstance().getDB();
        this.db.getCollection("users").drop();
        this.db.getCollection("settings").drop();
        this.userService = ServiceBootstrap.getUserService();
        this.chatService = ServiceBootstrap.getChatService();
        this.favoritesMigrationService = ServiceBootstrap.getFavoritesMigrationService();
    }

    @Test
    public void testUpgradeWithUsersTeamsAndSpacesRoomsInFavorites() {
        this.userService.addUserFullName("thomas", "Thomas Delhom\u00e9nie");
        this.userService.addUserFullName("john", "John Smith");
        this.userService.addUserFullName("mary", "Mary Williams");
        this.userService.addUserFullName("james", "James Doe");
        String roomThomasJohn = this.chatService.getRoom(Arrays.asList("thomas", "john"));
        String roomThomasMary = this.chatService.getRoom(Arrays.asList("thomas", "mary"));
        String roomThomasJames = this.chatService.getRoom(Arrays.asList("thomas", "james"));
        String roomJohnMary = this.chatService.getRoom(Arrays.asList("john", "mary"));
        String roomTeam1 = this.chatService.getTeamRoom("Team 1", "thomas");
        String roomTeam2 = this.chatService.getTeamRoom("Team 2", "thomas");
        String roomSpace1 = this.chatService.getSpaceRoom("Space 1");
        String roomSpace2 = this.chatService.getSpaceRoom("Space 2");
        String roomSpace3 = this.chatService.getSpaceRoom("Space 3");
        this.setOldFavoritesToUser("thomas", Arrays.asList("john", "mary", "team-" + roomTeam1, "space-" + roomSpace2, "space-" + roomSpace3));
        this.setOldFavoritesToUser("mary", Arrays.asList("john", "space-" + roomSpace3));
        this.favoritesMigrationService.processMigration();
        UserBean thomas = this.userService.getUser("thomas", true);
        Assert.assertNotNull((Object)thomas);
        List newThomasFavorites = thomas.getFavorites();
        Assert.assertNotNull((Object)newThomasFavorites);
        Assert.assertEquals((long)5L, (long)newThomasFavorites.size());
        Assert.assertTrue((boolean)newThomasFavorites.contains(roomThomasJohn));
        Assert.assertTrue((boolean)newThomasFavorites.contains(roomThomasMary));
        Assert.assertTrue((boolean)newThomasFavorites.contains(roomTeam1));
        Assert.assertTrue((boolean)newThomasFavorites.contains(roomSpace2));
        Assert.assertTrue((boolean)newThomasFavorites.contains(roomSpace2));
        UserBean john = this.userService.getUser("john", true);
        Assert.assertNotNull((Object)john);
        List newJohnFavorites = john.getFavorites();
        Assert.assertNull((Object)newJohnFavorites);
        UserBean mary = this.userService.getUser("mary", true);
        Assert.assertNotNull((Object)mary);
        List newMaryFavorites = mary.getFavorites();
        Assert.assertNotNull((Object)newMaryFavorites);
        Assert.assertEquals((long)2L, (long)newMaryFavorites.size());
        Assert.assertTrue((boolean)newThomasFavorites.contains(roomThomasMary));
        Assert.assertTrue((boolean)newThomasFavorites.contains(roomSpace3));
        Assert.assertEquals((Object)FavoritesMigrationService.FavoritesMigrationStatus.DONE, (Object)this.favoritesMigrationService.getMigrationStatus());
    }

    @Test
    public void testDoNotUpgradeWhenMigrationAlreadyDone() {
        ServiceBootstrap.getUserService().addUserFullName("thomas", "Thomas Delhom\u00e9nie");
        String roomTeam1 = ServiceBootstrap.getChatService().getTeamRoom("Team 1", "thomas");
        String roomSpace1 = ServiceBootstrap.getChatService().getSpaceRoom("Space 1");
        this.setOldFavoritesToUser("thomas", Arrays.asList("team-" + roomTeam1, "space-" + roomSpace1));
        ServiceBootstrap.getFavoritesMigrationService().setMigrationStatus(FavoritesMigrationService.FavoritesMigrationStatus.DONE);
        ServiceBootstrap.getFavoritesMigrationService().processMigration();
        UserBean thomas = ServiceBootstrap.getUserService().getUser("thomas", true);
        Assert.assertNotNull((Object)thomas);
        List newThomasFavorites = thomas.getFavorites();
        Assert.assertNotNull((Object)newThomasFavorites);
        Assert.assertEquals((long)2L, (long)newThomasFavorites.size());
        Assert.assertTrue((boolean)newThomasFavorites.contains("team-" + roomTeam1));
        Assert.assertTrue((boolean)newThomasFavorites.contains("space-" + roomSpace1));
        Assert.assertEquals((Object)FavoritesMigrationService.FavoritesMigrationStatus.DONE, (Object)ServiceBootstrap.getFavoritesMigrationService().getMigrationStatus());
    }

    private void setOldFavoritesToUser(String username, List<String> oldFavorites) {
        MongoBootstrap mongoBootstrap = ConnectionManager.getInstance();
        MongoDatabase db = mongoBootstrap.getDB();
        MongoCollection usersCol = db.getCollection("users");
        Bson searchQuery = Filters.eq((String)"user", (Object)username);
        Bson updateDocument = Updates.set((String)"favorites", oldFavorites);
        usersCol.updateMany(searchQuery, updateDocument);
    }
}

