/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.services.SettingDataStorage;

@Named(value="settingStorage")
@ApplicationScoped
@Singleton
public class SettingMongoDataStorage
implements SettingDataStorage {
    private static final Logger LOG = Logger.getLogger(SettingMongoDataStorage.class.getName());
    public static final String M_SETTINGS_COLLECTION = "settings";
    public static final String NAME = "name";
    public static final String VALUE = "value";

    private MongoDatabase db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public String getSetting(String name) {
        MongoCollection coll = this.db().getCollection(M_SETTINGS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)NAME, (Object)name);
        try (MongoCursor dbCursor = coll.find((Bson)query).cursor();){
            if (dbCursor.hasNext()) {
                String string = (String)((Document)dbCursor.next()).get((Object)VALUE);
                return string;
            }
        }
        return null;
    }

    @Override
    public void setSetting(String name, String value) {
        MongoCollection settingsCol = this.db().getCollection(M_SETTINGS_COLLECTION);
        Bson query = Filters.eq((String)NAME, (Object)name);
        Bson newStatusDBObject = Updates.combine((Bson[])new Bson[]{Updates.set((String)NAME, (Object)name), Updates.set((String)VALUE, (Object)value)});
        UpdateOptions options = new UpdateOptions().upsert(true);
        settingsCol.updateOne(query, newStatusDBObject, options);
    }
}

