/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.listener;

import java.util.Calendar;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;

public class UpdateUserStatusListener
extends Listener<ConversationRegistry, ConversationState> {
    public static final String STATUS_OFFLINE = "offline";

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        Identity identity;
        UserStateService userStateService = (UserStateService)CommonsUtils.getService(UserStateService.class);
        ConversationState data = (ConversationState)event.getData();
        if (data != null && (identity = data.getIdentity()) != null) {
            String userId = identity.getUserId();
            UserStateModel userStateModel = userStateService.getUserState(userId);
            if (userStateModel == null) {
                return;
            }
            userStateModel.setLastActivity(Calendar.getInstance().getTimeInMillis() - (long)userStateService.getDelay());
            userStateModel.setStatus(STATUS_OFFLINE);
            userStateService.save(userStateModel);
        }
    }
}

