/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.model;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.simple.JSONObject;

public class RealTimeMessageBean {
    private EventType event;
    private String room;
    private String sender;
    private Date timestamp;
    private Map<String, Object> data;

    public RealTimeMessageBean() {
    }

    public RealTimeMessageBean(EventType event, String room, String sender, Date timestamp, Map<String, Object> data) {
        this.event = event;
        this.room = room;
        this.sender = sender;
        this.timestamp = timestamp;
        this.data = data;
    }

    public EventType getEvent() {
        return this.event;
    }

    public void setEvent(EventType event) {
        this.event = event;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public String toJSON() {
        JSONObject message = new JSONObject();
        message.put((Object)"event", (Object)this.event.toString());
        message.put((Object)"room", (Object)this.room);
        message.put((Object)"sender", (Object)this.sender);
        if (this.timestamp == null) {
            message.put((Object)"ts", (Object)System.currentTimeMillis());
        } else {
            message.put((Object)"ts", (Object)this.timestamp.getTime());
        }
        if (this.data != null) {
            message.put((Object)"data", (Object)new JSONObject(this.data));
        }
        return message.toJSONString();
    }

    public static enum EventType {
        MESSAGE_SENT("message-sent"),
        MESSAGE_UPDATED("message-updated"),
        MESSAGE_DELETED("message-deleted"),
        MESSAGE_READ("message-read"),
        USER_STATUS_CHANGED("user-status-changed"),
        ROOM_MEMBER_JOIN("room-member-joined"),
        ROOM_MEMBER_LEFT("room-member-left"),
        ROOM_UPDATED("room-updated"),
        ROOM_DELETED("room-deleted"),
        FAVORITE_ADDED("favorite-added"),
        FAVORITE_REMOVED("favorite-removed"),
        ROOM_SETTINGS_UPDATED("room-settings-updated"),
        NOTIFICATION_COUNT_UPDATED("notification-count-updated");

        private final String eventType;
        private static Map<String, EventType> lookup;

        private EventType(String eventType) {
            this.eventType = eventType;
        }

        public String toString() {
            return this.eventType;
        }

        public static EventType get(String value) {
            if (lookup == null) {
                lookup = Arrays.stream(EventType.values()).collect(Collectors.toMap(e -> e.toString(), e -> e));
            }
            return lookup.get(value);
        }

        static {
            lookup = null;
        }
    }
}

