/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.listener;

import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.web.login.LogoutControl;

public class UpdateUserStatusListener
extends Listener<PortalContainer, HttpSessionEvent> {
    public static final String STATUS_OFFLINE = "offline";

    public void onEvent(Event<PortalContainer, HttpSessionEvent> event) {
        String userId;
        ConversationState conversationState = ConversationState.getCurrent();
        String string = userId = conversationState == null || conversationState.getIdentity() == null ? null : conversationState.getIdentity().getUserId();
        if (userId == null) {
            return;
        }
        PortalContainer portalContainer = (PortalContainer)event.getSource();
        if (LogoutControl.isLogoutRequired() && portalContainer.isStarted()) {
            UserStateService userStateService;
            UserStateModel userStateModel;
            String token = ServerBootstrap.getToken(userId);
            String dbName = ServerBootstrap.getDBName();
            ConversationRegistry conversationRegistry = (ConversationRegistry)portalContainer.getComponentInstanceOfType(ConversationRegistry.class);
            List stateKeys = conversationRegistry.getStateKeys(userId);
            stateKeys.remove(conversationState);
            HttpSessionEvent sessionEvent = (HttpSessionEvent)event.getData();
            HttpSession httpSession = sessionEvent.getSession();
            HttpSessionStateKey httpStateKey = new HttpSessionStateKey(httpSession);
            String sessionId = httpSession.getId();
            boolean isSingleSession = stateKeys.stream().filter(arg_0 -> UpdateUserStatusListener.lambda$onEvent$0((StateKey)httpStateKey, arg_0)).count() == 0L;
            ServerBootstrap.logout(userId, token, sessionId, dbName, isSingleSession);
            if (isSingleSession && (userStateModel = (userStateService = (UserStateService)portalContainer.getComponentInstanceOfType(UserStateService.class)).getUserState(userId)) != null) {
                userStateModel.setLastActivity(Calendar.getInstance().getTimeInMillis() - (long)userStateService.getDelay());
                userStateModel.setStatus(STATUS_OFFLINE);
                userStateService.save(userStateModel);
            }
        }
    }

    private static /* synthetic */ boolean lambda$onEvent$0(StateKey httpStateKey, StateKey stateKey) {
        return !stateKey.equals(httpStateKey);
    }
}

