/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import juzu.Path;
import juzu.impl.common.JSON;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.metamodel.AnnotationChange;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.MetaModelProcessor;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.template.metamodel.AbstractContainerMetaModel;
import juzu.impl.plugin.template.metamodel.ElementMetaModel;
import juzu.impl.plugin.template.metamodel.TagContainerMetaModel;
import juzu.impl.plugin.template.metamodel.TagMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateContainerMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateRefMetaModel;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.TagHandler;
import juzu.template.Tags;

public class TemplateMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private static final Set<Class<? extends Annotation>> PROCESSED = Collections.unmodifiableSet(Tools.set(Path.class, Tags.class));
    public static final Pattern PATH_PATTERN = Pattern.compile("([^/].*/|)([^./]+)\\.([a-zA-Z]+)");
    public final Map<String, TagHandler> tags = new HashMap<String, TagHandler>();
    Map<String, TemplateProvider> providers;

    public TemplateMetaModelPlugin() {
        super("template");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return PROCESSED;
    }

    @Override
    public void postActivate(ModuleMetaModel applications) {
        for (TagHandler handler : applications.getProcessingContext().loadServices(TagHandler.class)) {
            applications.getProcessingContext().info("Loaded tag handler " + handler.getClass().getName() + " as " + handler.getName());
            this.tags.put(handler.getName(), handler);
        }
        Iterable<TemplateProvider> loader = applications.processingContext.loadServices(TemplateProvider.class);
        HashMap<String, TemplateProvider> providers = new HashMap<String, TemplateProvider>();
        for (TemplateProvider provider : loader) {
            providers.put(provider.getSourceExtension(), provider);
        }
        this.providers = providers;
    }

    @Override
    public void init(ApplicationMetaModel application) {
        TemplateContainerMetaModel templates = new TemplateContainerMetaModel();
        templates.plugin = this;
        application.addChild(TemplateContainerMetaModel.KEY, templates);
        TagContainerMetaModel tags = new TagContainerMetaModel();
        tags.plugin = this;
        application.addChild(TagContainerMetaModel.KEY, tags);
    }

    @Override
    public void processAnnotationChange(ApplicationMetaModel metaModel, AnnotationChange change) {
        if (change.getKey().getType().toString().equals(Tags.class.getName())) {
            List tagsMember;
            TagContainerMetaModel tagContainer = metaModel.getChild(TagContainerMetaModel.KEY);
            HashMap<String, Path.Absolute> tagAnnotations = new HashMap<String, Path.Absolute>();
            if (change.getAdded() != null && (tagsMember = (List)change.getAdded().get("value")) != null) {
                for (AnnotationState tag : tagsMember) {
                    String name = (String)tag.get("name");
                    Path.Relative relativePath = (Path.Relative)juzu.impl.common.Path.parse((String)tag.get("path"));
                    Path.Absolute absolutePath = tagContainer.resolvePath(relativePath);
                    tagAnnotations.put(name, absolutePath);
                }
            }
            for (TagMetaModel tagMetaModel : tagContainer.getChildren(TagMetaModel.class)) {
                TemplateMetaModel template = tagMetaModel.getChild(TemplateMetaModel.KEY);
                if (template.getPath().equals(tagAnnotations.get(tagMetaModel.name))) {
                    tagAnnotations.remove(tagMetaModel.name);
                    continue;
                }
                tagMetaModel.remove();
            }
            for (Map.Entry entry : tagAnnotations.entrySet()) {
                tagContainer.add((String)entry.getKey(), (Path.Absolute)entry.getValue());
            }
        } else {
            super.processAnnotationChange(metaModel, change);
        }
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel application, AnnotationKey key, AnnotationState added) {
        if (key.getType().toString().equals(Path.class.getName())) {
            if (key.getElement() instanceof ElementHandle.Field) {
                ElementHandle.Field variableElt = (ElementHandle.Field)key.getElement();
                TemplateContainerMetaModel templates = application.getChild(TemplateContainerMetaModel.KEY);
                juzu.impl.common.Path addedPath = juzu.impl.common.Path.parse((String)added.get("value"));
                Path.Absolute absAdded = templates.resolvePath(addedPath);
                application.processingContext.info("Adding template ref " + variableElt.getTypeName() + "#" + variableElt.getName() + " " + absAdded);
                templates.add(variableElt, absAdded);
            } else {
                throw MetaModelProcessor.ANNOTATION_UNSUPPORTED.failure(key);
            }
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (key.getType().toString().equals(Path.class.getName()) && key.getElement() instanceof ElementHandle.Field) {
            ElementHandle.Field variableElt = (ElementHandle.Field)key.getElement();
            TemplateContainerMetaModel templates = metaModel.getChild(TemplateContainerMetaModel.KEY);
            juzu.impl.common.Path removedPath = juzu.impl.common.Path.parse((String)removed.get("value"));
            Path.Absolute absRemoved = templates.resolvePath(removedPath);
            metaModel.processingContext.info("Removing template ref " + variableElt.getTypeName() + "#" + variableElt.getName() + " " + absRemoved);
            templates.remove(variableElt);
        }
    }

    @Override
    public void postActivate(ApplicationMetaModel application) {
        application.getChild(TemplateContainerMetaModel.KEY).postActivate(this);
        application.getChild(TagContainerMetaModel.KEY).postActivate(this);
    }

    @Override
    public void prePassivate(ApplicationMetaModel application) {
        application.processingContext.info("Passivating template resolver for " + application.getHandle());
        application.getChild(TemplateContainerMetaModel.KEY).prePassivate();
        application.getChild(TagContainerMetaModel.KEY).prePassivate();
    }

    @Override
    public void prePassivate(ModuleMetaModel module) {
        module.processingContext.info("Passivating templates");
        this.tags.clear();
        this.providers = null;
    }

    @Override
    public void postProcessEvents(ApplicationMetaModel application) {
        application.processingContext.info("Processing templates of " + application.getHandle());
        application.getChild(TemplateContainerMetaModel.KEY).postProcessEvents();
        application.getChild(TagContainerMetaModel.KEY).postProcessEvents();
    }

    @Override
    public Iterable<? extends Completion> getCompletions(ApplicationMetaModel metaModel, AnnotationKey annotationKey, AnnotationState annotationState, String member, String userText) {
        List<Object> completions;
        block11: {
            completions = Collections.emptyList();
            DiskFileSystem sourcePath = metaModel.getProcessingContext().getSourcePath(metaModel.getHandle());
            if (sourcePath != null) {
                try {
                    File[] children;
                    File root = (File)sourcePath.getPath(metaModel.getChild(TemplateContainerMetaModel.KEY).getQN());
                    if (!root.isDirectory() || (children = root.listFiles()) == null) break block11;
                    if (userText != null && userText.length() > 0) {
                        try {
                            String suffix;
                            File from;
                            juzu.impl.common.Path path = juzu.impl.common.Path.parse(userText);
                            if (!path.isRelative()) break block11;
                            if (path.getExt() == null) {
                                from = sourcePath.getPath(root, path.getName());
                                if (from == null) {
                                    from = sourcePath.getPath(root, path.getDirs());
                                    suffix = path.getSimpleName();
                                } else {
                                    suffix = "";
                                }
                            } else {
                                from = sourcePath.getPath(root, path.getDirs());
                                suffix = path.getSimpleName();
                            }
                            if (from != null) {
                                completions = this.list(root, from, suffix);
                            }
                            break block11;
                        }
                        catch (IllegalArgumentException ignore) {}
                        break block11;
                    }
                    completions = this.list(root, root, "");
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
        return completions;
    }

    private void foo(StringBuilder buffer, File root, File file) {
        if (file.equals(root)) {
            buffer.setLength(0);
        } else {
            this.foo(buffer, root, file.getParentFile());
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            buffer.append(file.getName());
        }
    }

    private List<Completion> list(File root, File from, String suffix) {
        File[] children = from.listFiles();
        StringBuilder path = new StringBuilder();
        if (children != null) {
            ArrayList<Completion> completions = new ArrayList<Completion>();
            for (File child : children) {
                if (!child.getName().startsWith(suffix)) continue;
                this.foo(path, root, child);
                if (child.isDirectory()) {
                    path.append('/');
                }
                completions.add(Completions.of(path.toString()));
            }
            Collections.sort(completions, Tools.COMPLETION_COMPARATOR);
            return completions;
        }
        return Collections.emptyList();
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        JSON config = new JSON();
        AbstractContainerMetaModel metaModel = application.getChild(TemplateContainerMetaModel.KEY);
        LinkedHashSet<String> templates = new LinkedHashSet<String>();
        for (TemplateRefMetaModel ref : metaModel.getChildren(TemplateRefMetaModel.class)) {
            if (!(ref instanceof ElementMetaModel)) continue;
            templates.add(((ElementMetaModel)ref).getPath().getName().toString());
        }
        config.map("templates", templates);
        config.set("package", metaModel.getQN().toString());
        return config;
    }
}

