/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.util.HashSet;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.internal.cfg.DefaultConstraintMapping;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProviderKeyedByClassName;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ProgrammaticMetaDataProvider
extends MetaDataProviderKeyedByClassName {
    private static final Log log = LoggerFactory.make();
    private final AnnotationProcessingOptions annotationProcessingOptions;
    private final ParameterNameProvider parameterNameProvider;

    public ProgrammaticMetaDataProvider(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider, Set<DefaultConstraintMapping> constraintMappings) {
        super(constraintHelper);
        Contracts.assertNotNull(constraintMappings);
        this.parameterNameProvider = parameterNameProvider;
        this.assertUniquenessOfConfiguredTypes(constraintMappings);
        this.addAllBeanConfigurations(constraintMappings);
        this.annotationProcessingOptions = this.mergeAnnotationProcessingOptions(constraintMappings);
    }

    private void assertUniquenessOfConfiguredTypes(Set<DefaultConstraintMapping> mappings) {
        HashSet allConfiguredTypes = CollectionHelper.newHashSet();
        for (DefaultConstraintMapping constraintMapping : mappings) {
            for (Class<?> configuredType : constraintMapping.getConfiguredTypes()) {
                if (!allConfiguredTypes.contains(configuredType)) continue;
                throw log.getBeanClassHasAlreadyBeConfiguredViaProgrammaticApiException(configuredType.getName());
            }
            allConfiguredTypes.addAll(constraintMapping.getConfiguredTypes());
        }
    }

    private void addAllBeanConfigurations(Set<DefaultConstraintMapping> mappings) {
        for (DefaultConstraintMapping mapping : mappings) {
            Set<BeanConfiguration<?>> beanConfigurations = mapping.getBeanConfigurations(this.constraintHelper, this.parameterNameProvider);
            for (BeanConfiguration<?> beanConfiguration : beanConfigurations) {
                this.addBeanConfiguration(beanConfiguration.getBeanClass(), beanConfiguration);
            }
        }
    }

    private AnnotationProcessingOptions mergeAnnotationProcessingOptions(Set<DefaultConstraintMapping> mappings) {
        if (mappings.size() == 1) {
            return mappings.iterator().next().getAnnotationProcessingOptions();
        }
        AnnotationProcessingOptionsImpl options = new AnnotationProcessingOptionsImpl();
        for (DefaultConstraintMapping mapping : mappings) {
            options.merge(mapping.getAnnotationProcessingOptions());
        }
        return options;
    }

    @Override
    public AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }
}

