/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.ConstructorInstance;
import org.hibernate.validator.internal.util.privilegedactions.GetAnnotationParameter;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructor;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructors;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredFields;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetMethodFromPropertyName;
import org.hibernate.validator.internal.util.privilegedactions.GetMethods;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;

public final class ReflectionHelper {
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String ARRAY_CLASS_NAME_PREFIX = "[L";
    private static final String ARRAY_CLASS_NAME_SUFFIX = ";";
    private static final String PROPERTY_ACCESSOR_PREFIX_GET = "get";
    private static final String PROPERTY_ACCESSOR_PREFIX_IS = "is";
    private static final String PROPERTY_ACCESSOR_PREFIX_HAS = "has";
    private static final String[] PROPERTY_ACCESSOR_PREFIXES = new String[]{"get", "is", "has"};
    private static final Log log = LoggerFactory.make();
    private static final Map<String, Class<?>> PRIMITIVE_NAME_TO_PRIMITIVE;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPES;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPES;

    private ReflectionHelper() {
    }

    public static ClassLoader getClassLoaderFromContext() {
        return ReflectionHelper.run(GetClassLoader.fromContext());
    }

    public static ClassLoader getClassLoaderFromClass(Class<?> clazz) {
        return ReflectionHelper.run(GetClassLoader.fromClass(clazz));
    }

    public static Class<?> loadClass(String className, Class<?> caller) {
        return (Class)ReflectionHelper.run(LoadClass.action(className, caller));
    }

    public static Class<?> loadClass(String className, String defaultPackage) {
        return ReflectionHelper.loadClass(className, defaultPackage, ReflectionHelper.class);
    }

    public static Class<?> loadClass(String className, String defaultPackage, Class<?> caller) {
        if (PRIMITIVE_NAME_TO_PRIMITIVE.containsKey(className)) {
            return PRIMITIVE_NAME_TO_PRIMITIVE.get(className);
        }
        StringBuilder fullyQualifiedClass = new StringBuilder();
        String tmpClassName = className;
        if (ReflectionHelper.isArrayClassName(className)) {
            fullyQualifiedClass.append(ARRAY_CLASS_NAME_PREFIX);
            tmpClassName = ReflectionHelper.getArrayElementClassName(className);
        }
        if (ReflectionHelper.isQualifiedClass(tmpClassName)) {
            fullyQualifiedClass.append(tmpClassName);
        } else {
            fullyQualifiedClass.append(defaultPackage);
            fullyQualifiedClass.append(PACKAGE_SEPARATOR);
            fullyQualifiedClass.append(tmpClassName);
        }
        if (ReflectionHelper.isArrayClassName(className)) {
            fullyQualifiedClass.append(ARRAY_CLASS_NAME_SUFFIX);
        }
        return ReflectionHelper.loadClass(fullyQualifiedClass.toString(), caller);
    }

    private static boolean isArrayClassName(String className) {
        return className.startsWith(ARRAY_CLASS_NAME_PREFIX) && className.endsWith(ARRAY_CLASS_NAME_SUFFIX);
    }

    private static String getArrayElementClassName(String className) {
        return className.substring(2, className.length() - 1);
    }

    private static boolean isQualifiedClass(String clazz) {
        return clazz.contains(PACKAGE_SEPARATOR);
    }

    public static <T> T newInstance(Class<T> clazz, String message) {
        return ReflectionHelper.run(NewInstance.action(clazz, message));
    }

    public static <T> T newConstructorInstance(Constructor<T> constructor, Object ... initArgs) {
        return ReflectionHelper.run(ConstructorInstance.action(constructor, initArgs));
    }

    public static <T> T getAnnotationParameter(Annotation annotation, String parameterName, Class<T> type) {
        return ReflectionHelper.run(GetAnnotationParameter.action(annotation, parameterName, type));
    }

    public static String getPropertyName(Member member) {
        String name = null;
        if (member instanceof Field) {
            name = member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            for (String prefix : PROPERTY_ACCESSOR_PREFIXES) {
                if (!methodName.startsWith(prefix)) continue;
                name = StringHelper.decapitalize(methodName.substring(prefix.length()));
            }
        }
        return name;
    }

    public static boolean isGetterMethod(Method method) {
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        String methodName = method.getName();
        if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET) && method.getReturnType() != Void.TYPE) {
            return true;
        }
        if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS) && method.getReturnType() == Boolean.TYPE) {
            return true;
        }
        return methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_HAS) && method.getReturnType() == Boolean.TYPE;
    }

    public static Member getMember(Class<?> clazz, String property, ElementType elementType) {
        Contracts.assertNotNull(clazz, Messages.MESSAGES.classCannotBeNull());
        if (property == null || property.length() == 0) {
            throw log.getPropertyNameCannotBeNullOrEmptyException();
        }
        if (!ElementType.FIELD.equals((Object)elementType) && !ElementType.METHOD.equals((Object)elementType)) {
            throw log.getElementTypeHasToBeFieldOrMethodException();
        }
        Member member = null;
        if (ElementType.FIELD.equals((Object)elementType)) {
            member = ReflectionHelper.run(GetDeclaredField.action(clazz, property));
        } else {
            String prefix;
            String methodName = property.substring(0, 1).toUpperCase() + property.substring(1);
            String[] arr$ = PROPERTY_ACCESSOR_PREFIXES;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (member = (Member)ReflectionHelper.run(GetMethod.action(clazz, (prefix = arr$[i$]) + methodName))) == null; ++i$) {
            }
        }
        return member;
    }

    public static Type typeOf(Member member) {
        Type type;
        if (member instanceof Field) {
            type = ((Field)member).getGenericType();
        } else if (member instanceof Method) {
            type = ((Method)member).getGenericReturnType();
        } else if (member instanceof Constructor) {
            type = member.getDeclaringClass();
        } else {
            throw log.getMemberIsNeitherAFieldNorAMethodException(member);
        }
        if (type instanceof TypeVariable) {
            type = TypeHelper.getErasedType(type);
        }
        return type;
    }

    public static Type typeOf(ExecutableElement executable, int parameterIndex) {
        Type type;
        Type[] genericParameterTypes = executable.getGenericParameterTypes();
        if (parameterIndex >= genericParameterTypes.length) {
            genericParameterTypes = executable.getParameterTypes();
        }
        if ((type = genericParameterTypes[parameterIndex]) instanceof TypeVariable) {
            type = TypeHelper.getErasedType(type);
        }
        return type;
    }

    public static Object getValue(Member member, Object object) {
        if (member instanceof Method) {
            return ReflectionHelper.getValue((Method)member, object);
        }
        if (member instanceof Field) {
            return ReflectionHelper.getValue((Field)member, object);
        }
        return null;
    }

    public static Object getValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw log.getUnableToAccessMemberException(field.getName(), e);
        }
    }

    public static Object getValue(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw log.getUnableToAccessMemberException(method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw log.getUnableToAccessMemberException(method.getName(), e);
        }
    }

    public static void setAccessibility(Member member) {
        ReflectionHelper.run(SetAccessibility.action(member));
    }

    public static Type getIndexedType(Type type) {
        Type indexedType = null;
        if (ReflectionHelper.isIterable(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[0];
        } else if (ReflectionHelper.isMap(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[1];
        } else if (TypeHelper.isArray(type)) {
            indexedType = TypeHelper.getComponentType(type);
        }
        return indexedType;
    }

    public static boolean isIterable(Type type) {
        if (type instanceof Class && Iterable.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isIterable(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isIterable(upperBounds[0]);
        }
        return false;
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isMap(upperBounds[0]);
        }
        return false;
    }

    public static boolean isList(Type type) {
        if (type instanceof Class && List.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isList(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isList(upperBounds[0]);
        }
        return false;
    }

    public static Object getIndexedValue(Object value, Integer index) {
        Iterator<Object> iter;
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
        } else if (TypeHelper.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
        } else {
            return null;
        }
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (i == index) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static Object getMappedValue(Object value, Object key) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        return map.get(key);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        return ReflectionHelper.run(GetDeclaredField.action(clazz, fieldName));
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return ReflectionHelper.run(GetDeclaredFields.action(clazz));
    }

    public static Method getMethodFromPropertyName(Class<?> clazz, String methodName) {
        return ReflectionHelper.run(GetMethodFromPropertyName.action(clazz, methodName));
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        return ReflectionHelper.run(GetMethod.action(clazz, methodName));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionHelper.run(GetDeclaredMethod.action(clazz, methodName, parameterTypes));
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectionHelper.run(GetDeclaredMethods.action(clazz));
    }

    public static Method[] getMethods(Class<?> clazz) {
        return ReflectionHelper.run(GetMethods.action(clazz));
    }

    public static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        return ReflectionHelper.run(GetDeclaredConstructors.action(clazz));
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... params) {
        return (Constructor)ReflectionHelper.run(GetDeclaredConstructor.action(clazz, params));
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    public static Class<?> boxedType(Class<?> primitiveType) {
        Class<?> wrapperType = PRIMITIVE_TO_WRAPPER_TYPES.get(primitiveType);
        if (wrapperType == null) {
            throw log.getHasToBeAPrimitiveTypeException(primitiveType.getClass());
        }
        return wrapperType;
    }

    public static Class<?> unBoxedType(Class<?> type) {
        Class<?> wrapperType = WRAPPER_TO_PRIMITIVE_TYPES.get(type);
        if (wrapperType == null) {
            throw log.getHasToBeABoxedTypeException(type.getClass());
        }
        return wrapperType;
    }

    static {
        HashMap<Object, Class<Object>> tmpMap = CollectionHelper.newHashMap(9);
        tmpMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        tmpMap.put(Character.TYPE.getName(), Character.TYPE);
        tmpMap.put(Double.TYPE.getName(), Double.TYPE);
        tmpMap.put(Float.TYPE.getName(), Float.TYPE);
        tmpMap.put(Long.TYPE.getName(), Long.TYPE);
        tmpMap.put(Integer.TYPE.getName(), Integer.TYPE);
        tmpMap.put(Short.TYPE.getName(), Short.TYPE);
        tmpMap.put(Byte.TYPE.getName(), Byte.TYPE);
        tmpMap.put(Void.TYPE.getName(), Void.TYPE);
        PRIMITIVE_NAME_TO_PRIMITIVE = Collections.unmodifiableMap(tmpMap);
        tmpMap = CollectionHelper.newHashMap(9);
        tmpMap.put(Boolean.TYPE, Boolean.class);
        tmpMap.put(Character.TYPE, Character.class);
        tmpMap.put(Double.TYPE, Double.class);
        tmpMap.put(Float.TYPE, Float.class);
        tmpMap.put(Long.TYPE, Long.class);
        tmpMap.put(Integer.TYPE, Integer.class);
        tmpMap.put(Short.TYPE, Short.class);
        tmpMap.put(Byte.TYPE, Byte.class);
        tmpMap.put(Void.TYPE, Void.TYPE);
        PRIMITIVE_TO_WRAPPER_TYPES = Collections.unmodifiableMap(tmpMap);
        tmpMap = CollectionHelper.newHashMap(9);
        tmpMap.put(Boolean.class, Boolean.TYPE);
        tmpMap.put(Character.class, Character.TYPE);
        tmpMap.put(Double.class, Double.TYPE);
        tmpMap.put(Float.class, Float.TYPE);
        tmpMap.put(Long.class, Long.TYPE);
        tmpMap.put(Integer.class, Integer.TYPE);
        tmpMap.put(Short.class, Short.TYPE);
        tmpMap.put(Byte.class, Byte.TYPE);
        tmpMap.put(Void.TYPE, Void.TYPE);
        WRAPPER_TO_PRIMITIVE_TYPES = Collections.unmodifiableMap(tmpMap);
    }
}

