/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.notification.pwa;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;

public class ChatMentionPwaNotificationPlugin
implements PwaNotificationPlugin {
    private ResourceBundleService resourceBundleService;
    private PermanentLinkService permanentLinkService;
    private static final String TITLE_LABEL_KEY = "pwa.notification.ChatMentionPlugin.title";

    public ChatMentionPwaNotificationPlugin(ResourceBundleService resourceBundleService, PermanentLinkService permanentLinkService) {
        this.permanentLinkService = permanentLinkService;
        this.resourceBundleService = resourceBundleService;
    }

    public String getId() {
        return "ChatMentionNotificationPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String title = this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter("senderFullName")).replace("{1}", notification.getValueOwnerParameter("roomName"));
        notificationMessage.setTitle(title);
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(new PermanentLinkObject("chatRoom", notification.getValueOwnerParameter("roomId"))));
        return notificationMessage;
    }
}

