/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.samples;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.samples.DemoBase;

public final class ClassBodyDemo {
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] args) throws Exception {
        String classBody;
        int i;
        if (args.length > 0 && args[0].equals("-help")) {
            System.out.println("Usage:");
            System.out.println("  ClassBodyDemo <class-body> { <argument> }");
            System.out.println("  ClassBodyDemo -help");
            System.out.println("If <class-body> starts with a '@', then the class body is read");
            System.out.println("from the named file.");
            System.out.println("The <class-body> must declare a method \"public static main(String[])\"");
            System.out.println("to which the <argument>s are passed. If the return type of that method is");
            System.out.println("not VOID, then the returned value is printed to STDOUT.");
            System.exit(0);
        }
        if ((i = 0) >= args.length) {
            System.err.println("Class body missing; try \"-help\".");
        }
        if ((classBody = args[i++]).startsWith("@")) {
            classBody = ClassBodyDemo.readFileToString(classBody.substring(1));
        }
        String[] arguments = new String[args.length - i];
        System.arraycopy(args, i, arguments, 0, arguments.length);
        IClassBodyEvaluator cbe = CompilerFactoryFactory.getDefaultCompilerFactory().newClassBodyEvaluator();
        cbe.cook(classBody);
        Class c = cbe.getClazz();
        Method m = c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ClassBodyDemo.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        Object returnValue = m.invoke(null, new Object[]{arguments});
        if (m.getReturnType() != Void.TYPE) {
            System.out.println(DemoBase.toString(returnValue));
        }
    }

    private ClassBodyDemo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileToString(String fileName) throws IOException {
        FileReader r = new FileReader(fileName);
        try {
            int cnt;
            StringBuffer sb = new StringBuffer();
            char[] ca = new char[1024];
            while ((cnt = ((Reader)r).read(ca, 0, ca.length)) != -1) {
                sb.append(ca, 0, cnt);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            ((Reader)r).close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

