/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.nio.charset.StandardCharsets;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.res.StringManager;

public class Cookie {
    private static final Log log;
    private static final UserDataHelper invalidCookieLog;
    private static final StringManager sm;
    private static final boolean[] isCookieOctet;
    private static final boolean[] isText;
    private static final byte[] EMPTY_BYTES;
    private static final byte TAB_BYTE = 9;
    private static final byte SPACE_BYTE = 32;
    private static final byte QUOTE_BYTE = 34;
    private static final byte COMMA_BYTE = 44;
    private static final byte SEMICOLON_BYTE = 59;
    private static final byte EQUALS_BYTE = 61;
    private static final byte SLASH_BYTE = 92;
    private static final byte DEL_BYTE = 127;

    private Cookie() {
    }

    public static void parseCookie(byte[] bytes, int offset, int len, ServerCookies serverCookies) {
        ByteBuffer bb = new ByteBuffer(bytes, offset, len);
        boolean moreToProcess = true;
        while (moreToProcess) {
            Cookie.skipLWS(bb);
            int start = bb.position();
            ByteBuffer name = Cookie.readToken(bb);
            ByteBuffer value = null;
            Cookie.skipLWS(bb);
            SkipResult skipResult = Cookie.skipByte(bb, (byte)61);
            if (skipResult == SkipResult.FOUND) {
                Cookie.skipLWS(bb);
                value = Cookie.readCookieValueRfc6265(bb);
                if (value == null) {
                    Cookie.skipUntilSemiColon(bb);
                    Cookie.logInvalidHeader(start, bb);
                    continue;
                }
                Cookie.skipLWS(bb);
            }
            if ((skipResult = Cookie.skipByte(bb, (byte)59)) != SkipResult.FOUND) {
                if (skipResult == SkipResult.NOT_FOUND) {
                    Cookie.skipUntilSemiColon(bb);
                    Cookie.logInvalidHeader(start, bb);
                    continue;
                }
                moreToProcess = false;
            }
            if (!name.hasRemaining()) continue;
            ServerCookie sc = serverCookies.addCookie();
            sc.getName().setBytes(name.array(), name.position(), name.remaining());
            if (value == null) {
                sc.getValue().setBytes(EMPTY_BYTES, 0, EMPTY_BYTES.length);
                continue;
            }
            sc.getValue().setBytes(value.array(), value.position(), value.remaining());
        }
    }

    private static void skipLWS(ByteBuffer bb) {
        while (bb.hasRemaining()) {
            byte b = bb.get();
            if (b == 9 || b == 32) continue;
            bb.rewind();
            break;
        }
    }

    private static void skipUntilSemiColon(ByteBuffer bb) {
        while (bb.hasRemaining() && bb.get() != 59) {
        }
    }

    private static SkipResult skipByte(ByteBuffer bb, byte target) {
        if (!bb.hasRemaining()) {
            return SkipResult.EOF;
        }
        if (bb.get() == target) {
            return SkipResult.FOUND;
        }
        bb.rewind();
        return SkipResult.NOT_FOUND;
    }

    private static ByteBuffer readCookieValueRfc6265(ByteBuffer bb) {
        boolean quoted = false;
        if (bb.hasRemaining()) {
            if (bb.get() == 34) {
                quoted = true;
            } else {
                bb.rewind();
            }
        }
        int start = bb.position();
        int end = bb.limit();
        while (bb.hasRemaining()) {
            byte b = bb.get();
            if (isCookieOctet[b & 0xFF]) continue;
            if (b == 59 || b == 32 || b == 9) {
                end = bb.position() - 1;
                bb.position(end);
                break;
            }
            if (quoted && b == 34) {
                end = bb.position() - 1;
                break;
            }
            return null;
        }
        return new ByteBuffer(bb.bytes, start, end - start);
    }

    private static ByteBuffer readToken(ByteBuffer bb) {
        int start = bb.position();
        int end = bb.limit();
        while (bb.hasRemaining()) {
            if (HttpParser.isToken(bb.get())) continue;
            end = bb.position() - 1;
            bb.position(end);
            break;
        }
        return new ByteBuffer(bb.bytes, start, end - start);
    }

    private static void logInvalidHeader(int start, ByteBuffer bb) {
        UserDataHelper.Mode logMode = invalidCookieLog.getNextMode();
        if (logMode != null) {
            String headerValue = new String(bb.array(), start, bb.position() - start, StandardCharsets.UTF_8);
            Object message = sm.getString("cookie.invalidCookieValue", new Object[]{headerValue});
            switch (logMode) {
                case INFO_THEN_DEBUG: {
                    message = (String)message + sm.getString("cookie.fallToDebug");
                }
                case INFO: {
                    log.info(message);
                    break;
                }
                case DEBUG: {
                    log.debug(message);
                }
            }
        }
    }

    static {
        int i;
        log = LogFactory.getLog(Cookie.class);
        invalidCookieLog = new UserDataHelper(log);
        sm = StringManager.getManager((String)"org.apache.tomcat.util.http.parser");
        isCookieOctet = new boolean[256];
        isText = new boolean[256];
        EMPTY_BYTES = new byte[0];
        for (i = 0; i < 256; ++i) {
            Cookie.isCookieOctet[i] = i >= 33 && i != 34 && i != 44 && i != 59 && i != 92 && i != 127;
        }
        for (i = 0; i < 256; ++i) {
            Cookie.isText[i] = i >= 9 && (i <= 9 || i >= 32) && i != 127;
        }
    }

    private static class ByteBuffer {
        private final byte[] bytes;
        private int limit;
        private int position = 0;

        ByteBuffer(byte[] bytes, int offset, int len) {
            this.bytes = bytes;
            this.position = offset;
            this.limit = offset + len;
        }

        public int position() {
            return this.position;
        }

        public void position(int position) {
            this.position = position;
        }

        public int limit() {
            return this.limit;
        }

        public int remaining() {
            return this.limit - this.position;
        }

        public boolean hasRemaining() {
            return this.position < this.limit;
        }

        public byte get() {
            return this.bytes[this.position++];
        }

        public void rewind() {
            --this.position;
        }

        public byte[] array() {
            return this.bytes;
        }

        public String toString() {
            return "position [" + this.position + "], limit [" + this.limit + "]";
        }
    }
}

