/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.ResourceHandlerBase;
import ch.qos.logback.core.util.OptionHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;

public class IncludeModelHandler
extends ResourceHandlerBase {
    boolean inError = false;

    public IncludeModelHandler(Context context) {
        super(context);
    }

    public static IncludeModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        return new IncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        IncludeModel includeModel = (IncludeModel)model;
        this.optional = OptionHelper.toBoolean(includeModel.getOptional(), false);
        if (!this.checkAttributes(includeModel)) {
            this.inError = true;
            return;
        }
        InputStream in = this.getInputStream(mic, includeModel);
        if (in == null) {
            this.inError = true;
            return;
        }
        SaxEventRecorder recorder = null;
        try {
            recorder = this.populateSaxEventRecorder(in);
            List<SaxEvent> saxEvents = recorder.getSaxEventList();
            if (saxEvents.isEmpty()) {
                this.addWarn("Empty sax event list");
                return;
            }
            Supplier<? extends GenericXMLConfigurator> jcSupplier = mic.getConfiguratorSupplier();
            if (jcSupplier == null) {
                this.addError("null configurator supplier. Abandoning inclusion of [" + this.attributeInUse + "]");
                this.inError = true;
                return;
            }
            GenericXMLConfigurator genericXMLConfigurator = jcSupplier.get();
            genericXMLConfigurator.getRuleStore().addPathPathMapping("included", "configuration");
            Model modelFromIncludedFile = genericXMLConfigurator.buildModelFromSaxEventList(recorder.getSaxEventList());
            if (modelFromIncludedFile == null) {
                this.addError("Could not find valid configuration instructions. Exiting.");
                return;
            }
            includeModel.getSubModels().addAll(modelFromIncludedFile.getSubModels());
        }
        catch (JoranException e) {
            this.inError = true;
            this.addError("Error processing XML data in [" + this.attributeInUse + "]", e);
        }
    }

    public SaxEventRecorder populateSaxEventRecorder(InputStream inputStream) throws JoranException {
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        recorder.recordEvents(inputStream);
        return recorder;
    }

    private InputStream getInputStream(ModelInterpretationContext mic, IncludeModel includeModel) {
        URL inputURL = this.getInputURL(mic, includeModel);
        if (inputURL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, inputURL);
        return this.openURL(inputURL);
    }
}

