/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.addons.chat.utils.MessageDigester;
import org.exoplatform.addons.chat.utils.PropertyManager;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/chat/api/1.0/user/")
public class UserRestService
implements ResourceContainer {
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String ANONIM_USER = "__anonim_";

    @GET
    @Path(value="/token/")
    public Response getToken(@QueryParam(value="tokenOnly") String tokenOnly) throws Exception {
        String token;
        boolean withTokenOnly;
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        boolean bl = withTokenOnly = tokenOnly != null && "true".equals(tokenOnly);
        if ("__anonim".equals(userId)) {
            userId = ANONIM_USER;
            token = "---";
        } else {
            String passphrase = PropertyManager.getProperty("chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        }
        if (withTokenOnly) {
            return Response.ok((Object)token, (String)"text/plain").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\"username\":\"").append(userId).append("\",");
        sb.append("\"token\":\"").append(token).append("\"}");
        return Response.ok((Object)sb.toString(), (String)"application/json").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }
}

