/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.api;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.addons.chat.utils.MessageDigester;
import org.exoplatform.addons.chat.utils.PropertyManager;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/chat/api/1.0/user/")
public class UserRestService
implements ResourceContainer {
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String ANONIM_USER = "__anonim_";

    @GET
    @Path(value="/getAvatarURL/{userId}/")
    @RolesAllowed(value={"users"})
    public Response getAvatarURL(@PathParam(value="userId") String userId, @Context UriInfo uri) {
        CacheControl cacheControl = new CacheControl();
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        String scheme = uri.getBaseUri().getScheme();
        String serverName = uri.getBaseUri().getHost();
        int serverPort = uri.getBaseUri().getPort();
        String serverBase = scheme + "://" + serverName;
        if (serverPort != 80) {
            serverBase = serverBase + ":" + serverPort;
        }
        InputStream in = null;
        try {
            URL url = new URL(serverBase + "/rest/jcr/repository/social/production/soc:providers/soc:organization/soc:" + userId + "/soc:profile/soc:avatar");
            URLConnection con = url.openConnection();
            con.setDoOutput(true);
            in = con.getInputStream();
        }
        catch (Exception e) {
            try {
                URL url = new URL(serverBase + "/social-resources/skin/images/ShareImages/UserAvtDefault.png");
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                in = con.getInputStream();
            }
            catch (Exception e1) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        return Response.ok((Object)in, (String)"Image").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/token/")
    public Response getToken(@QueryParam(value="tokenOnly") String tokenOnly) throws Exception {
        String token;
        boolean withTokenOnly;
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        boolean bl = withTokenOnly = tokenOnly != null && "true".equals(tokenOnly);
        if ("__anonim".equals(userId)) {
            userId = ANONIM_USER;
            token = "---";
        } else {
            String passphrase = PropertyManager.getProperty("chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        }
        if (withTokenOnly) {
            return Response.ok((Object)token, (String)"text/plain").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\"username\":\"").append(userId).append("\",");
        sb.append("\"token\":\"").append(token).append("\"}");
        return Response.ok((Object)sb.toString(), (String)"application/json").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }
}

