/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class PropertyManager {
    private static final Logger LOG = Logger.getLogger(PropertyManager.class.getName());
    private static Properties properties;
    private static final String PROPERTIES_PATH;
    public static final String PROPERTY_SYSTEM_PREFIX = "chat.";
    public static final String PROPERTY_PASSPHRASE = "chatPassPhrase";

    public static String getProperty(String key) {
        String value = (String)PropertyManager.properties().get(key);
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    private static synchronized Properties properties() {
        if (properties == null) {
            properties = new Properties();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(PROPERTIES_PATH);
                properties.load(stream);
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
            }
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PASSPHRASE, "chat");
        }
        return properties;
    }

    private static void overridePropertyIfNotSet(String key, String value) {
        if (PropertyManager.properties().getProperty(key) == null) {
            PropertyManager.properties().setProperty(key, value);
        }
        if (System.getProperty(PROPERTY_SYSTEM_PREFIX + key) != null) {
            PropertyManager.properties().setProperty(key, System.getProperty(PROPERTY_SYSTEM_PREFIX + key));
        }
    }

    public static void overrideProperty(String key, String value) {
        PropertyManager.properties().setProperty(key, value);
    }

    static {
        String chatConfDir = System.getProperty("exo.chat.conf");
        if (StringUtils.isEmpty((String)chatConfDir)) {
            chatConfDir = System.getProperty("exo.conf.dir") + "/chat.properties";
        }
        PROPERTIES_PATH = chatConfDir;
    }
}

