/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services.jcr;

import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.benjp.model.UserBean;
import org.benjp.services.TokenService;
import org.benjp.services.jcr.AbstractJCRService;
import org.benjp.services.jcr.JCRBootstrap;
import org.benjp.utils.MessageDigester;
import org.benjp.utils.PropertyManager;

public class TokenServiceImpl
extends AbstractJCRService
implements TokenService {
    private int validity_ = -1;

    public TokenServiceImpl() {
        this.initNodetypes();
        this.initMandatoryNodes();
    }

    @Override
    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty("chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash(in);
        return token;
    }

    @Override
    public boolean hasUserWithToken(String user, String token) {
        try {
            Session session = JCRBootstrap.getSession();
            Node tokensNode = session.getRootNode().getNode("chat/tokens");
            if (tokensNode.hasNode(user)) {
                Node tokenNode = tokensNode.getNode(user);
                String tokenUser = tokenNode.getProperty("chat:token").getString();
                return token.equals(tokenUser);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void addUser(String user, String token) {
        try {
            Session session = JCRBootstrap.getSession();
            Node tokensNode = session.getRootNode().getNode("chat/tokens");
            if (!tokensNode.hasNode(user)) {
                Node tokenNode = tokensNode.addNode(user, "chat:token");
                session.save();
                tokenNode.setProperty("chat:user", user);
                tokenNode.setProperty("chat:token", token);
                tokenNode.setProperty("chat:validity", System.currentTimeMillis());
                tokenNode.setProperty("chat:isdemouser", user.startsWith("__anonim_"));
                tokenNode.save();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateValidity(String user, String token) {
        try {
            Node tokenNode;
            String tokenUser;
            Session session = JCRBootstrap.getSession();
            Node tokensNode = session.getRootNode().getNode("chat/tokens");
            if (tokensNode.hasNode(user) && token.equals(tokenUser = (tokenNode = tokensNode.getNode(user)).getProperty("chat:token").getString())) {
                tokenNode.setProperty("chat:validity", System.currentTimeMillis());
                tokenNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public HashMap<String, UserBean> getActiveUsersFilterBy(String user, boolean withUsers, boolean withPublic, boolean isAdmin) {
        return this.getActiveUsersFilterBy(user, withUsers, withPublic, isAdmin, 0);
    }

    @Override
    public HashMap<String, UserBean> getActiveUsersFilterBy(String user, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        HashMap<String, UserBean> users2 = new HashMap<String, UserBean>();
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:token").append(" WHERE ");
            statement.append("chat:validity").append(" > ").append(System.currentTimeMillis() - (long)this.getValidity());
            if (isAdmin) {
                if (withPublic && !withUsers) {
                    statement.append(" AND ").append("chat:isdemouser").append(" = 'true' ");
                } else if (!withPublic && withUsers) {
                    statement.append(" AND ").append("chat:isdemouser").append(" = 'false' ");
                }
            } else {
                statement.append(" AND ").append("chat:isdemouser").append(" = '").append(user.startsWith("__anonim_")).append("'");
            }
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                String target = node.getProperty("chat:user").getString();
                if (user.equals(target)) continue;
                UserBean userBean = new UserBean();
                userBean.setName(target);
                users2.put(target, userBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users2;
    }

    @Override
    public boolean isUserOnline(String user) {
        try {
            Node tokenNode;
            Session session = JCRBootstrap.getSession();
            Node tokensNode = session.getRootNode().getNode("chat/tokens");
            if (tokensNode.hasNode(user) && (tokenNode = tokensNode.getNode(user)).hasProperty("chat:validity")) {
                long validity = tokenNode.getProperty("chat:validity").getLong();
                return validity > System.currentTimeMillis() - (long)this.getValidity();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isDemoUser(String user) {
        return user.startsWith("__anonim_");
    }

    private int getValidity() {
        if (this.validity_ == -1) {
            this.validity_ = 25000;
            try {
                this.validity_ = new Integer(PropertyManager.getProperty("chatTokenValidity"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity_;
    }
}

