/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.benjp.model.NotificationBean;
import org.benjp.services.NotificationService;
import org.benjp.services.jcr.AbstractJCRService;
import org.benjp.services.jcr.JCRBootstrap;
import org.exoplatform.services.jcr.util.IdGenerator;

public class NotificationServiceImpl
extends AbstractJCRService
implements NotificationService {
    @Override
    public void addNotification(String user, String from, String type, String category, String categoryId, String content, String link) {
        try {
            Session session = JCRBootstrap.getSession();
            Node notifsNode = session.getRootNode().getNode("chat/notifications");
            String id = IdGenerator.generate();
            Node notifNode = notifsNode.addNode(id, "chat:notification");
            notifNode.setProperty("chat:timestamp", System.currentTimeMillis());
            notifNode.setProperty("chat:user", user);
            notifNode.setProperty("chat:from", from);
            notifNode.setProperty("chat:type", type);
            notifNode.setProperty("chat:category", category);
            notifNode.setProperty("chat:categoryid", categoryId);
            notifNode.setProperty("chat:content", content);
            notifNode.setProperty("chat:link", link);
            notifNode.setProperty("chat:isread", false);
            session.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNotificationsAsRead(String user, String type, String category, String categoryId) {
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:notification").append(" WHERE ");
            statement.append("chat:user").append(" = '").append(user).append("' ");
            if (categoryId != null) {
                statement.append(" AND ").append("chat:categoryid").append(" = '").append(categoryId).append("' ");
            }
            if (category != null) {
                statement.append(" AND ").append("chat:category").append(" = '").append(category).append("' ");
            }
            if (type != null) {
                statement.append(" AND ").append("chat:type").append(" = '").append(type).append("' ");
            }
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                node.setProperty("chat:isread", true);
                node.save();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user) {
        return this.getUnreadNotifications(user, null, null, null);
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user, String type, String category, String categoryId) {
        ArrayList<NotificationBean> notifications = new ArrayList<NotificationBean>();
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:notification").append(" WHERE ");
            statement.append("chat:user").append(" = '").append(user).append("' ");
            statement.append(" AND ").append("chat:isread").append(" = 'false' ");
            if (categoryId != null) {
                statement.append(" AND ").append("chat:categoryid").append(" = '").append(categoryId).append("' ");
            }
            if (category != null) {
                statement.append(" AND ").append("chat:category").append(" = '").append(category).append("' ");
            }
            if (type != null) {
                statement.append(" AND ").append("chat:type").append(" = '").append(type).append("' ");
            }
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                NotificationBean notificationBean = new NotificationBean();
                notificationBean.setTimestamp(node.getProperty("chat:timestamp").getLong());
                notificationBean.setUser(user);
                if (node.hasProperty("chat:from")) {
                    notificationBean.setFrom(node.getProperty("chat:from").getString());
                }
                notificationBean.setCategory(node.getProperty("chat:category").getString());
                notificationBean.setCategoryId(node.getProperty("chat:categoryid").getString());
                notificationBean.setType(node.getProperty("chat:type").getString());
                notificationBean.setContent(node.getProperty("chat:content").getString());
                notificationBean.setLink(node.getProperty("chat:link").getString());
                notifications.add(notificationBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifications;
    }

    @Override
    public int getUnreadNotificationsTotal(String user) {
        return this.getUnreadNotificationsTotal(user, null, null, null);
    }

    @Override
    public int getUnreadNotificationsTotal(String user, String type, String category, String categoryId) {
        int total = -1;
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:notification").append(" WHERE ");
            statement.append("chat:user").append(" = '").append(user).append("' ");
            statement.append(" AND ").append("chat:isread").append(" = 'false' ");
            if (categoryId != null) {
                statement.append(" AND ").append("chat:categoryid").append(" = '").append(categoryId).append("' ");
            }
            if (category != null) {
                statement.append(" AND ").append("chat:category").append(" = '").append(category).append("' ");
            }
            if (type != null) {
                statement.append(" AND ").append("chat:type").append(" = '").append(type).append("' ");
            }
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            total = Integer.parseInt("" + nodeIterator.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return total;
    }

    @Override
    public int getNumberOfNotifications() {
        int total = -1;
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:notification");
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            total = Integer.parseInt("" + nodeIterator.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return total;
    }

    @Override
    public int getNumberOfUnreadNotifications() {
        int total = -1;
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:notification");
            statement.append(" WHERE ").append("chat:isread").append(" = 'false'");
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            total = Integer.parseInt("" + nodeIterator.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return total;
    }

    public static void cleanupNotifications() {
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:notification");
            statement.append(" WHERE ").append("chat:isread").append(" = 'true'");
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                node.remove();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

