/*
 * Copyright (C) 2012 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.exoplatform.chat.services;

import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;

import java.util.List;

public interface ChatService
{
  public static final String M_ROOM_PREFIX = "messages_room_";
  public static final String M_ROOMS_COLLECTION = "rooms";

  public static final String SPACE_PREFIX = "space-";
  public static final String TEAM_PREFIX = "team-";
  public static final String EXTERNAL_PREFIX = "external-";

  public static final String TYPE_ROOM_USER = "u";
  public static final String TYPE_ROOM_SPACE = "s";
  public static final String TYPE_ROOM_TEAM = "t";
  public static final String TYPE_ROOM_EXTERNAL = "e";

  public static final String TYPE_DELETED = "DELETED";
  public static final String TYPE_EDITED = "EDITED";

  public void write(String message, String user, String room, String isSystem, String dbName);

  public void write(String message, String user, String room, String isSystem, String options, String dbName);

  public void delete(String room, String user, String messageId, String dbName);

  public void edit(String room, String user, String messageId, String message, String dbName);

  public String read(String room, UserService userService, String dbName);

  public String read(String room, UserService userService, boolean isTextOnly, Long fromTimestamp, String dbName);

  public String read(String room, UserService userService, boolean isTextOnly, Long fromTimestamp, Long toTimestamp, String dbName);

  public String getSpaceRoom(String space, String dbName);

  public String getSpaceRoomByName(String name, String dbName);

  public String getTeamRoom(String team, String user, String dbName);

  public String getExternalRoom(String identifier, String dbName);

  public String getTeamCreator(String room, String dbName);

  public void setRoomName(String room, String name, String dbName);

  public String getRoom(List<String> users, String dbName);
  
  public String getTypeRoomChat(String roomId, String dbName);

  public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService, String dbName);

  public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, NotificationService notificationService, UserService userService, TokenService tokenService, String dbName);

  public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, int limit, NotificationService notificationService, UserService userService, TokenService tokenService, String dbName);

  public int getNumberOfRooms(String dbName);

  public int getNumberOfMessages(String dbName);

}
