/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.TokenStorage;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.user.UserStateService;

@Named(value="tokenService")
@ApplicationScoped
public class TokenServiceImpl
implements TokenService {
    private UserStateService userStateService;
    @Inject
    private TokenStorage storage;

    public TokenServiceImpl() {
        this.userStateService = (UserStateService)PortalContainer.getInstance().getComponentInstanceOfType(UserStateService.class);
    }

    public TokenServiceImpl(UserStateService userStateService) {
        this.userStateService = userStateService;
    }

    @Override
    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty("chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash(in);
        return token;
    }

    @Override
    public boolean hasUserWithToken(String user, String token, String dbName) {
        return this.storage.hasUserWithToken(user, token, dbName);
    }

    @Override
    public void addUser(String user, String token, String dbName) {
        this.storage.addUser(user, token, dbName);
    }

    @Override
    public Map<String, UserBean> getActiveUsersFilterBy(String user, String dbName, boolean withUsers, boolean withPublic, boolean isAdmin) {
        return this.getActiveUsersFilterBy(user, dbName, withUsers, withPublic, isAdmin, 0);
    }

    @Override
    public Map<String, UserBean> getActiveUsersFilterBy(String user, String dbName, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        List<String> onlineUsers = this.userStateService.online().stream().map(u -> u.getUserId()).collect(Collectors.toList());
        return this.storage.getActiveUsersFilterBy(user, onlineUsers, dbName, withUsers, withPublic, isAdmin, limit);
    }

    @Override
    public boolean isUserOnline(String user, String dbName) {
        return this.userStateService != null ? this.userStateService.isOnline(user) : false;
    }

    @Override
    public boolean isDemoUser(String user) {
        return user.startsWith("__anonim_");
    }
}

