/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.cometd.bayeux.Session;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.container.PortalContainer;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@Named(value="realTimeMessageService")
@ApplicationScoped
public class CometdMessageServiceImpl
implements RealTimeMessageService {
    public static final String COMETD_CHANNEL_NAME = "/service/chat";
    private EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(EXoContinuationBayeux.class);

    @Override
    public void sendMessage(RealTimeMessageBean realTimeMessageBean, String receiver) {
        if (this.bayeux.isPresent(receiver)) {
            this.bayeux.sendMessage(receiver, COMETD_CHANNEL_NAME, (Object)realTimeMessageBean.toJSON(), null);
        }
    }

    @Override
    public void sendMessage(RealTimeMessageBean realTimeMessageBean, List<String> receivers) {
        receivers.stream().filter(u -> this.bayeux.isPresent(u)).forEach(u -> this.bayeux.sendMessage(u, COMETD_CHANNEL_NAME, (Object)realTimeMessageBean.toJSON(), null));
    }

    @Override
    public void sendMessageToAll(RealTimeMessageBean realTimeMessageBean) {
        this.bayeux.getSessions().stream().forEach(s -> s.deliver((Session)s, COMETD_CHANNEL_NAME, (Object)realTimeMessageBean.toJSON()));
    }
}

