/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.ChatDataStorage;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.PropertyManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Named(value="chatService")
@ApplicationScoped
@Singleton
public class ChatServiceImpl
implements ChatService {
    private static final Logger LOG = Logger.getLogger("ChatService");
    @Inject
    private ChatDataStorage chatStorage;
    @Inject
    private UserService userService;
    @Inject
    private NotificationService notificationService;
    @Inject
    private RealTimeMessageService realTimeMessageService;

    @Override
    public void write(String message, String user, String room, String isSystem, String dbName) {
        this.write(null, message, user, room, isSystem, null, dbName);
    }

    @Override
    public void write(String tempId, String message, String sender, String room, String isSystem, String options, String dbName) {
        if (!this.isMemberOfRoom(sender, room, dbName)) {
            throw new ChatException(403, "Petit malin !");
        }
        if (isSystem == null) {
            isSystem = "false";
        }
        String msgId = this.chatStorage.save(message, sender, room, isSystem, options, dbName);
        RoomBean roomBean = this.userService.getRoom(sender, room, dbName);
        String roomType = roomBean.getType();
        if (!"e".equals(roomType)) {
            List<Object> usersToBeNotified = new ArrayList<String>();
            if ("u".equals(roomType)) {
                usersToBeNotified.add(roomBean.getUser());
            } else {
                usersToBeNotified = this.userService.getUsersFilterBy(sender, room, roomType, dbName);
            }
            MessageBean msg = this.chatStorage.getMessage(room, msgId, dbName);
            UserBean user = this.userService.getUser(sender, dbName);
            msg.setFullName(user.getFullname());
            JSONObject data = msg.toJSONObject();
            data.put((Object)"tempId", (Object)tempId);
            data.put((Object)"roomType", (Object)roomType);
            if ("u".equals(roomType)) {
                data.put((Object)"roomDisplayName", (Object)user.getFullname());
            } else {
                data.put((Object)"roomDisplayName", (Object)roomBean.getFullName());
            }
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_SENT, room, user.getName(), new Date(), (Map<String, Object>)data);
            this.realTimeMessageService.sendMessage(messageBean, sender);
            String intranetPage = PropertyManager.getProperty("chatPortalPage");
            String content = message.length() > 30 ? message.substring(0, 29) + "..." : message;
            for (String string : usersToBeNotified) {
                this.notificationService.addNotification(string, sender, "chat", "room", room, content, intranetPage + "?room=" + room, options, dbName);
                this.realTimeMessageService.sendMessage(messageBean, string);
            }
            this.notificationService.setNotificationsAsRead(sender, "chat", "room", room, dbName);
        }
    }

    @Override
    public String save(String message, String user, String room, String isSystem, String options, String dbName) {
        return this.chatStorage.save(message, user, room, isSystem, options, dbName);
    }

    @Override
    public void delete(String room, String sender, String messageId, String dbName) {
        this.chatStorage.delete(room, sender, messageId, dbName);
        String roomType = this.getTypeRoomChat(room, dbName);
        if (!roomType.equals("e")) {
            ArrayList<String> usersToBeNotified = new ArrayList<String>();
            if (roomType.equals("s")) {
                usersToBeNotified = this.userService.getUsersFilterBy(sender, room, "s", dbName);
            } else if (roomType.equals("t")) {
                usersToBeNotified = this.userService.getUsersFilterBy(sender, room, "t", dbName);
            } else {
                usersToBeNotified.add(room);
            }
            MessageBean msg = this.chatStorage.getMessage(room, messageId, dbName);
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_DELETED, room, sender, new Date(), (Map<String, Object>)msg.toJSONObject());
            this.realTimeMessageService.sendMessage(messageBean, sender);
            this.realTimeMessageService.sendMessage(messageBean, usersToBeNotified);
        }
    }

    @Override
    public RoomBean getTeamRoomById(String roomId, String dbName) {
        return this.chatStorage.getTeamRoomById(roomId, dbName);
    }

    @Override
    public void deleteTeamRoom(String room, String user, String dbName) {
        List<String> usersToBeNotified = this.userService.getUsersFilterBy(user, room, "t", dbName);
        this.chatStorage.deleteTeamRoom(room, user, dbName);
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_DELETED, room, user, new Date(), null);
        this.realTimeMessageService.sendMessage(messageBean, user);
        this.realTimeMessageService.sendMessage(messageBean, usersToBeNotified);
    }

    @Override
    public void edit(String room, String sender, String messageId, String message, String dbName) {
        this.chatStorage.edit(room, sender, messageId, message, dbName);
        RoomBean roomBean = this.userService.getRoom(sender, room, dbName);
        String roomType = roomBean.getType();
        if (!"e".equals(roomType)) {
            ArrayList<String> usersToBeNotified = new ArrayList<String>();
            if ("u".equals(roomType)) {
                usersToBeNotified.add(roomBean.getUser());
            } else {
                usersToBeNotified = this.userService.getUsersFilterBy(sender, room, roomType, dbName);
            }
            MessageBean msg = this.chatStorage.getMessage(room, messageId, dbName);
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_UPDATED, room, sender, new Date(), (Map<String, Object>)msg.toJSONObject());
            this.realTimeMessageService.sendMessage(messageBean, sender);
            this.realTimeMessageService.sendMessage(messageBean, usersToBeNotified);
        }
    }

    @Override
    public String read(String user, String room, String dbName) {
        return this.read(user, room, false, null, null, dbName);
    }

    @Override
    public String read(String user, String room, boolean isTextOnly, Long fromTimestamp, String dbName) {
        return this.read(user, room, isTextOnly, fromTimestamp, null, dbName);
    }

    @Override
    public String read(String user, String room, boolean isTextOnly, Long fromTimestamp, Long toTimestamp, String dbName) {
        if (!this.isMemberOfRoom(user, room, dbName)) {
            throw new ChatException(403, "Petit malin !");
        }
        return this.chatStorage.read(room, isTextOnly, fromTimestamp, toTimestamp, dbName);
    }

    @Override
    public MessageBean getMessage(String roomId, String messageId, String dbName) {
        return this.chatStorage.getMessage(roomId, messageId, dbName);
    }

    @Override
    public String getSpaceRoom(String space, String dbName) {
        return this.chatStorage.getSpaceRoom(space, dbName);
    }

    @Override
    public String getSpaceRoomByName(String name, String dbName) {
        return this.chatStorage.getSpaceRoomByName(name, dbName);
    }

    @Override
    public String getTeamRoom(String team, String user, String dbName) {
        return this.chatStorage.getTeamRoom(team, user, dbName);
    }

    @Override
    public String getExternalRoom(String identifier, String dbName) {
        return this.chatStorage.getExternalRoom(identifier, dbName);
    }

    @Override
    public String getTeamCreator(String room, String dbName) {
        return this.chatStorage.getTeamCreator(room, dbName);
    }

    @Override
    public void setRoomName(String room, String name, String dbName) {
        this.chatStorage.setRoomName(room, name, dbName);
        List<String> users = this.userService.getUsersFilterBy(null, room, "t", dbName);
        JSONObject data = new JSONObject();
        data.put((Object)"title", (Object)name);
        JSONArray array = new JSONArray();
        array.addAll(users);
        data.put((Object)"members", (Object)array);
        RealTimeMessageBean updatedRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_UPDATED, room, null, null, (Map<String, Object>)data);
        for (String u : users) {
            this.realTimeMessageService.sendMessage(updatedRoomMessage, u);
        }
    }

    @Override
    public String getRoom(List<String> users, String dbName) {
        return this.chatStorage.getRoom(users, dbName);
    }

    @Override
    public String getTypeRoomChat(String roomId, String dbName) {
        return this.chatStorage.getTypeRoomChat(roomId, dbName);
    }

    @Override
    public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService, String dbName) {
        return this.chatStorage.getExistingRooms(user, withPublic, isAdmin, notificationService, tokenService, dbName);
    }

    @Override
    public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, NotificationService notificationService, TokenService tokenService, String dbName) {
        return this.getRooms(user, filter, withUsers, withSpaces, withPublic, withOffline, isAdmin, 0, notificationService, tokenService, dbName);
    }

    @Override
    public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, int limit, NotificationService notificationService, TokenService tokenService, String dbName) {
        return this.chatStorage.getRooms(user, filter, withUsers, withSpaces, withPublic, withOffline, isAdmin, limit, notificationService, tokenService, dbName);
    }

    @Override
    public int getNumberOfRooms(String dbName) {
        return this.chatStorage.getNumberOfRooms(dbName);
    }

    @Override
    public int getNumberOfMessages(String dbName) {
        return this.chatStorage.getNumberOfMessages(dbName);
    }

    private boolean isMemberOfRoom(String username, String roomId, String dbName) {
        List<String> roomMembers;
        RoomBean room = this.userService.getRoom(username, roomId, dbName);
        if (room == null) {
            LOG.warning("Cannot check if user " + username + " is member of room " + roomId + " since the room does not exist.");
            return false;
        }
        if (room.getType().equals("t")) {
            roomMembers = this.userService.getUsersFilterBy(null, roomId, "t", dbName);
        } else if (room.getType().equals("s")) {
            roomMembers = this.userService.getUsersFilterBy(null, roomId, "s", dbName);
        } else {
            roomMembers = new ArrayList<String>();
            List<UserBean> userBeans = this.userService.getUsersInRoomChatOneToOne(roomId, dbName);
            if (userBeans != null) {
                for (UserBean userBean : userBeans) {
                    roomMembers.add(userBean.getName());
                }
            }
        }
        return roomMembers != null && roomMembers.contains(username);
    }
}

