/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import java.io.IOException;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.impl.common.Tools;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;

@ApplicationScoped
public class ChatTools {
    private static final Logger LOG = Logger.getLogger("ChatTools");
    UserService userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
    TokenService tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);
    NotificationService notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);

    @Resource
    @Route(value="/addUser")
    public Response.Content addUser(String username, String token, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        this.tokenService.addUser(username, token, dbName);
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/setAsAdmin")
    public Response.Content setAsAdmin(String username, String isAdmin, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        this.userService.setAsAdmin(username, "true".equals(isAdmin), dbName);
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/addUserFullNameAndEmail")
    public Response.Content addUserFullNameAndEmail(String username, String fullname, String email, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        try {
            this.userService.addUserEmail(username, email, dbName);
            fullname = (String)ChatUtils.fromString(fullname);
            this.userService.addUserFullName(username, fullname, dbName);
        }
        catch (Exception e) {
            LOG.info("fullname wasn't serialized : " + e.getMessage());
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/setSpaces")
    public Response.Content setSpaces(String username, String spaces, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        try {
            SpaceBeans spaceBeans = (SpaceBeans)ChatUtils.fromString(spaces);
            this.userService.setSpaces(username, spaceBeans.getSpaces(), dbName);
        }
        catch (IOException e) {
            LOG.warning(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            LOG.warning(e.getMessage());
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/getUserFullName")
    public Response.Content getUserFullName(String username, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        String fullname = this.userService.getUserFullName(username, dbName);
        return Response.ok((CharSequence)String.valueOf(fullname)).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/updateUnreadTestMessages")
    public Response.Content updateUnreadTestMessages(String username, String room, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (username == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"username is null\"}");
        }
        if (room == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"room is null\"}");
        }
        if (username.startsWith("space-")) {
            return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
        }
        if (!room.equals("ALL")) {
            this.notificationService.setNotificationsAsRead(username, "chat", "room", room, dbName);
        } else {
            this.notificationService.setNotificationsAsRead(username, null, null, null, dbName);
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/initDB")
    public Response.Content initDB(String db, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        ConnectionManager.getInstance().getDB(db);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"using db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/dropDB")
    public Response.Content dropDB(String db, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        ConnectionManager.getInstance().dropDB(db);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"deleting db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/ensureIndexes")
    public Response.Content ensureIndexes(String db, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        if (!db.equals(ConnectionManager.getInstance().getDB().getName())) {
            return Response.notFound((CharSequence)"{ \"message\": \"db name doesn't match\"}");
        }
        ConnectionManager.getInstance().ensureIndexes();
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"indexes created or updated on db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    private boolean checkPassphrase(String passphrase) {
        boolean checkPP = false;
        if (PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            checkPP = true;
        }
        if ("".equals(passphrase) || "chat".equals(passphrase)) {
            LOG.warning("ChatServer is not secured! Please change 'chatPassPhrase' property in " + PropertyManager.PROPERTIES_PATH);
        }
        return checkPP;
    }
}

