/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.TokenStorage;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.services.user.UserStateService;

@Named(value="tokenService")
@ApplicationScoped
@Singleton
public class TokenServiceImpl
implements TokenService {
    @Inject
    private TokenStorage storage;

    public TokenServiceImpl() {
    }

    public TokenServiceImpl(UserStateService userStateService) {
    }

    @Override
    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty("chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash(in);
        return token;
    }

    @Override
    public boolean hasUserWithToken(String user, String token) {
        return this.hasUserWithToken(user, token, null);
    }

    @Override
    public boolean hasUserWithToken(String user, String token, String dbName) {
        return this.storage.hasUserWithToken(user, token, dbName);
    }

    @Override
    public void addUser(String user, String token, String dbName) {
        this.storage.addUser(user, token, dbName);
    }

    @Override
    public Map<String, UserBean> getActiveUsersFilterBy(String user, List<String> limitUsers, String dbName, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        return this.storage.getActiveUsersFilterBy(user, limitUsers, dbName, withUsers, withPublic, isAdmin, limit);
    }

    @Override
    public boolean isDemoUser(String user) {
        return user.startsWith("__anonim_");
    }
}

