/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.RestrictedSignIn;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IRestrictedSignInCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IRestrictedSignInCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RestrictedSignInCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RestrictedSignInCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RestrictedSignInCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RestrictedSignInRequestBuilder;

public class RestrictedSignInCollectionRequest
extends BaseCollectionRequest<RestrictedSignInCollectionResponse, IRestrictedSignInCollectionPage>
implements IRestrictedSignInCollectionRequest {
    public RestrictedSignInCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RestrictedSignInCollectionResponse.class, IRestrictedSignInCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRestrictedSignInCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(RestrictedSignInCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRestrictedSignInCollectionPage get() throws ClientException {
        RestrictedSignInCollectionResponse response = (RestrictedSignInCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(RestrictedSignIn newRestrictedSignIn, ICallback<RestrictedSignIn> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new RestrictedSignInRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRestrictedSignIn, callback);
    }

    @Override
    public RestrictedSignIn post(RestrictedSignIn newRestrictedSignIn) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RestrictedSignInRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRestrictedSignIn);
    }

    @Override
    public IRestrictedSignInCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IRestrictedSignInCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRestrictedSignInCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IRestrictedSignInCollectionPage buildFromResponse(RestrictedSignInCollectionResponse response) {
        RestrictedSignInCollectionRequestBuilder builder = response.nextLink != null ? new RestrictedSignInCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RestrictedSignInCollectionPage page = new RestrictedSignInCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

