/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.Folder;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.models.extensions.ItemReference;
import com.microsoft.graph.models.extensions.User;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import com.microsoft.graph.requests.extensions.IDriveItemDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveItemDeltaCollectionRequestBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.RefreshAccessException;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveAPI;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveException;
import org.exoplatform.services.cms.clouddrives.onedrive.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OneDriveAPITest {
    static IGraphServiceClient graphClient;
    static OneDriveAPI oneDriveAPI;
    static String rootId;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void init() throws IOException, CloudDriveException {
        OneDriveAPITest.initGraphClient();
        OneDriveAPITest.initOneDriveAPI();
    }

    private static void initOneDriveAPI() throws IOException, CloudDriveException {
        Properties properties = new Properties();
        properties.load(ClassLoader.getSystemClassLoader().getResourceAsStream("onedrive.properties"));
        oneDriveAPI = new OneDriveAPI(properties.getProperty("clientId"), properties.getProperty("clientSecret"), "", TestUtil.getRefreshToken(), 10L, "");
    }

    private static void initGraphClient() {
        graphClient = GraphServiceClient.builder().authenticationProvider(iHttpRequest -> {
            String accessToken = TestUtil.retrieveAccessToken();
            iHttpRequest.getHeaders().add(new HeaderOption("Authorization", "Bearer " + accessToken));
        }).buildClient();
        rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
    }

    @Before
    public void initOneDriveAPIRemoveItems() {
        this.removeAll();
    }

    @Test
    public void getRoot() throws IOException, CloudDriveException {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        Assert.assertEquals((Object)rootId, (Object)oneDriveAPI.getRootId());
    }

    @Test
    public void getUser() throws IOException {
        User expectedUser = graphClient.me().buildRequest().get();
        User actualUser = oneDriveAPI.getUser();
        Assert.assertEquals((Object)expectedUser.id, (Object)actualUser.id);
        Assert.assertEquals((Object)expectedUser.userPrincipalName, (Object)actualUser.userPrincipalName);
    }

    @Test
    public void insertShouldReturnAppropriateItem() throws Exception {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        byte[] testFile = new byte[]{1, 2, 3, -2, 4, 2, 2};
        String fileName = "file.txt";
        Calendar created = Calendar.getInstance();
        Calendar modified = Calendar.getInstance();
        DriveItem item = oneDriveAPI.insert(rootId, fileName, created, modified, (InputStream)new ByteArrayInputStream(testFile), "rename");
        Assert.assertEquals((Object)fileName, (Object)item.name);
        Assert.assertEquals((long)testFile.length, (long)item.size);
        Assert.assertEquals((Object)rootId, (Object)item.parentReference.id);
    }

    @Test
    public void insertShouldCreateFile() throws Exception {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        byte[] testFile = new byte[]{1, 2, 3, -2, 4, 2, 2};
        String fileName = "file.txt";
        Calendar created = Calendar.getInstance();
        Calendar modified = Calendar.getInstance();
        DriveItem expectedItem = oneDriveAPI.insert(rootId, fileName, created, modified, (InputStream)new ByteArrayInputStream(testFile), "rename");
        List items = graphClient.me().drive().root().children().buildRequest().get().getCurrentPage();
        Assert.assertEquals((long)1L, (long)items.size());
        DriveItem actualItem = (DriveItem)items.get(0);
        Assert.assertEquals((Object)expectedItem.size, (Object)actualItem.size);
        Assert.assertEquals((Object)expectedItem.name, (Object)actualItem.name);
        Assert.assertEquals((Object)expectedItem.parentReference.id, (Object)actualItem.parentReference.id);
        Assert.assertEquals((Object)expectedItem.id, (Object)actualItem.id);
    }

    @Test
    public void createFolderShouldReturnAprrortiateItem() {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        String fileName = "f1.test";
        Calendar created = Calendar.getInstance();
        DriveItem item = oneDriveAPI.createFolder(rootId, fileName, created);
        Assert.assertEquals((Object)rootId, (Object)item.parentReference.id);
        Assert.assertEquals((Object)fileName, (Object)item.name);
        Assert.assertNotNull((Object)item.folder);
    }

    @Test
    public void createFolder() {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        DriveItem expectedItem = oneDriveAPI.createFolder(rootId, "createdFile.test", Calendar.getInstance());
        List items = graphClient.me().drive().root().children().buildRequest().get().getCurrentPage();
        DriveItem actualItem = (DriveItem)items.get(0);
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertNotNull((Object)actualItem.folder);
        Assert.assertEquals((Object)expectedItem.id, (Object)actualItem.id);
        Assert.assertEquals((Object)expectedItem.size, (Object)actualItem.size);
        Assert.assertEquals((Object)expectedItem.name, (Object)actualItem.name);
        Assert.assertEquals((Object)expectedItem.parentReference.id, (Object)actualItem.parentReference.id);
        Assert.assertEquals((Object)expectedItem.id, (Object)actualItem.id);
        Assert.assertEquals((long)expectedItem.fileSystemInfo.createdDateTime.getTimeInMillis(), (long)actualItem.fileSystemInfo.createdDateTime.getTimeInMillis());
        Assert.assertEquals((long)expectedItem.fileSystemInfo.lastModifiedDateTime.getTimeInMillis(), (long)actualItem.fileSystemInfo.lastModifiedDateTime.getTimeInMillis());
    }

    @Test
    public void removeFile() throws InterruptedException {
        List items = this.addThreeFiles().stream().map(item -> item.id).collect(Collectors.toList());
        String removedDriveItemId = (String)items.remove(0);
        List expectedItems = items;
        oneDriveAPI.removeFile(removedDriveItemId);
        List actualItems = graphClient.me().drive().root().children().buildRequest().get().getCurrentPage().stream().map(item -> item.id).collect(Collectors.toList());
        Assert.assertTrue((expectedItems.size() == actualItems.size() && expectedItems.containsAll(actualItems) && actualItems.containsAll(expectedItems) ? 1 : 0) != 0);
        this.exception.expect(GraphServiceException.class);
        graphClient.me().drive().items(removedDriveItemId).buildRequest().get();
    }

    @Test
    public void children() throws CloudDriveException {
        List expectedItems = this.addThreeFiles().stream().map(item -> item.id).collect(Collectors.toList());
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        OneDriveAPI.ChildIterator ch = oneDriveAPI.getChildIterator(rootId);
        ArrayList<String> actualItems = new ArrayList<String>();
        while (ch.hasNext()) {
            actualItems.add(((DriveItem)ch.next()).id);
        }
        Assert.assertTrue((expectedItems.size() == actualItems.size() && expectedItems.containsAll(actualItems) && actualItems.containsAll(expectedItems) ? 1 : 0) != 0);
    }

    @Test
    public void createLink() throws OneDriveException {
        List items = this.addThreeFiles().stream().map(item -> item.id).collect(Collectors.toList());
        String itemId = (String)items.get(1);
        String expectedLink = OneDriveAPITest.oneDriveAPI.createLink((String)itemId, (String)"embed").webUrl;
        String actualLink = OneDriveAPITest.graphClient.me().drive().items((String)itemId).createLink((String)"embed", null).buildRequest().post().link.webUrl;
        Assert.assertEquals((Object)expectedLink, (Object)actualLink);
    }

    @Test
    public void getItemShouldReturnAppropriateItem() {
        List items = this.addThreeFiles().stream().map(item -> item.id).collect(Collectors.toList());
        String itemId = (String)items.get(0);
        DriveItem actualItem = oneDriveAPI.getItem(itemId);
        Assert.assertEquals((Object)itemId, (Object)actualItem.id);
    }

    @Test
    public void getItem() {
        List items = this.addThreeFiles().stream().map(item -> item.id).collect(Collectors.toList());
        String itemId = (String)items.get(0);
        DriveItem expectedItem = oneDriveAPI.getItem(itemId);
        DriveItem actualItem = graphClient.me().drive().items(itemId).buildRequest().get();
        Assert.assertEquals((Object)expectedItem.id, (Object)actualItem.id);
        Assert.assertEquals((Object)expectedItem.size, (Object)actualItem.size);
        Assert.assertEquals((Object)expectedItem.name, (Object)actualItem.name);
        Assert.assertEquals((Object)expectedItem.parentReference.id, (Object)actualItem.parentReference.id);
        Assert.assertEquals((Object)expectedItem.id, (Object)actualItem.id);
        Assert.assertEquals((long)expectedItem.fileSystemInfo.createdDateTime.getTimeInMillis(), (long)actualItem.fileSystemInfo.createdDateTime.getTimeInMillis());
        Assert.assertEquals((long)expectedItem.fileSystemInfo.lastModifiedDateTime.getTimeInMillis(), (long)actualItem.fileSystemInfo.lastModifiedDateTime.getTimeInMillis());
    }

    @Test
    public void renameFile() {
        List<DriveItem> items = this.addThreeFiles();
        DriveItem item = this.renamedItem(items.get(0), "renFile.test");
        DriveItem expectedItem = oneDriveAPI.updateFile(item);
        DriveItem actualItem = graphClient.me().drive().items(item.id).buildRequest().get();
        Assert.assertEquals((Object)expectedItem.id, (Object)actualItem.id);
        Assert.assertEquals((Object)expectedItem.size, (Object)actualItem.size);
        Assert.assertEquals((Object)expectedItem.name, (Object)actualItem.name);
        Assert.assertEquals((Object)expectedItem.parentReference.id, (Object)actualItem.parentReference.id);
        Assert.assertEquals((Object)expectedItem.id, (Object)actualItem.id);
    }

    @Test
    public void moveFileShouldReturnAppropriateItem() throws CloudDriveException, URISyntaxException {
        DriveItem destFolder = this.addThreeFolders().get(0);
        DriveItem srcItem = this.addThreeFiles().get(0);
        srcItem.parentReference.id = destFolder.id;
        DriveItem destItem = oneDriveAPI.updateFile(srcItem);
        Assert.assertEquals((Object)srcItem.id, (Object)destItem.id);
        Assert.assertEquals((Object)srcItem.name, (Object)destItem.name);
        Assert.assertEquals((Object)destFolder.id, (Object)destItem.parentReference.id);
    }

    @Test
    public void moveFile() throws CloudDriveException, URISyntaxException {
        DriveItem destFolder = this.addThreeFolders().get(0);
        DriveItem srcItem = this.addThreeFiles().get(0);
        srcItem.parentReference.id = destFolder.id;
        oneDriveAPI.updateFile(srcItem);
        DriveItem movedItem = graphClient.me().drive().items(srcItem.id).buildRequest().get();
        Assert.assertEquals((Object)srcItem.name, (Object)movedItem.name);
        Assert.assertEquals((Object)destFolder.id, (Object)movedItem.parentReference.id);
    }

    @Test
    public void copyShouldCreateFileAtDestination() throws OneDriveException, RefreshAccessException {
        DriveItem testFolder = this.addThreeFolders().get(0);
        String parentId = testFolder.id;
        DriveItem testFile = this.addThreeFiles().get(0);
        String fileId = testFile.id;
        String fileName = testFile.name;
        oneDriveAPI.copy(parentId, fileName, fileId, true);
        List testFolderChildren = graphClient.me().drive().items(testFolder.id).children().buildRequest().get().getCurrentPage();
        Assert.assertEquals((long)1L, (long)testFolderChildren.size());
        DriveItem copiedFile = (DriveItem)testFolderChildren.get(0);
        Assert.assertEquals((Object)copiedFile.name, (Object)testFile.name);
        Assert.assertEquals((Object)copiedFile.size, (Object)testFile.size);
    }

    @Test
    public void copyShouldNotRemoveItem() throws OneDriveException, RefreshAccessException {
        DriveItem testFolder = this.addThreeFolders().get(0);
        String parentId = testFolder.id;
        DriveItem testFile = this.addThreeFiles().get(0);
        String testFileId = testFile.id;
        String testFileName = testFile.name;
        oneDriveAPI.copy(parentId, testFileName, testFileId, true);
        boolean isFilePresent = graphClient.me().drive().root().children().buildRequest().get().getCurrentPage().stream().anyMatch(item -> item.id.equals(testFileId));
        Assert.assertTrue((boolean)isFilePresent);
    }

    @Test
    public void getAllFiles() {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        List<DriveItem> files = this.addThreeFiles();
        List<DriveItem> actualItems = oneDriveAPI.getAllFiles().getItems().stream().filter(item -> !rootId.equals(item.id)).collect(Collectors.toList());
        this.assertListDriveItemEquals(files, actualItems);
    }

    @Test
    public void fileUploadShouldBeInChanges() throws CloudDriveException {
        String fileName = "testFile.txt";
        byte[] fileContent = "some text".getBytes(Charset.forName("UTF-8"));
        IDriveItemDeltaCollectionPage collectionPage = graphClient.me().drive().root().delta().buildRequest().get();
        String deltaLink = ((IDriveItemDeltaCollectionRequestBuilder)collectionPage.getNextPage()).buildRequest().get().deltaLink();
        String deltaToken = deltaLink.substring(deltaLink.indexOf("=") + 1);
        this.addFile(rootId, fileName, fileContent);
        OneDriveAPI.ChangesIterator changes = oneDriveAPI.changes(deltaToken);
        ArrayList<DriveItem> newItems = new ArrayList<DriveItem>();
        while (changes.hasNext()) {
            DriveItem item = (DriveItem)changes.next();
            if (item.id.equals(rootId)) continue;
            newItems.add(item);
        }
        Assert.assertEquals((long)1L, (long)newItems.size());
        DriveItem newItem = (DriveItem)newItems.get(0);
        Assert.assertEquals((Object)fileName, (Object)newItem.name);
        Assert.assertEquals((long)fileContent.length, (long)newItem.size);
    }

    private List<DriveItem> addThreeFolders() {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        String folderName1 = "fol1";
        String folderName2 = "fol2";
        String folderName3 = "fol3";
        ArrayList<DriveItem> folders = new ArrayList<DriveItem>();
        folders.add(this.addFolder(rootId, folderName1));
        folders.add(this.addFolder(rootId, folderName2));
        folders.add(this.addFolder(rootId, folderName3));
        return folders;
    }

    private DriveItem addFolder(String parentId, String name) {
        DriveItem folder = new DriveItem();
        folder.name = name;
        folder.parentReference = new ItemReference();
        folder.parentReference.id = parentId;
        folder.folder = new Folder();
        return graphClient.me().drive().items(parentId).children().buildRequest().post(folder);
    }

    private DriveItem addFile(String parentId, String fileName, byte[] testFile) {
        return graphClient.me().drive().items(parentId + ":/" + fileName + ":").content().buildRequest().put(testFile);
    }

    private void removeAll() {
        List items = graphClient.me().drive().root().children().buildRequest().get().getCurrentPage();
        for (DriveItem item : items) {
            graphClient.me().drive().items(item.id).buildRequest().delete();
        }
    }

    private List<DriveItem> addThreeFiles() {
        String rootId = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        String fileName1 = "file1.test";
        String fileName2 = "file2.test";
        String fileName3 = "file3.test";
        byte[] testFile1 = new byte[]{2, 3, 4, 100, -22, -23, 54};
        byte[] testFile2 = new byte[]{12, 32, 42, 100, 54};
        byte[] testFile3 = new byte[]{2, 113, 4, 99, 54};
        ArrayList<DriveItem> items = new ArrayList<DriveItem>();
        items.add(this.addFile(rootId, fileName1, testFile1));
        items.add(this.addFile(rootId, fileName2, testFile2));
        items.add(this.addFile(rootId, fileName3, testFile3));
        return items;
    }

    private DriveItem renamedItem(DriveItem driveItem, String name) {
        DriveItem item = new DriveItem();
        item.id = driveItem.id;
        item.name = name;
        item.parentReference = new ItemReference();
        item.parentReference.id = OneDriveAPITest.graphClient.me().drive().root().buildRequest().get().id;
        return item;
    }

    public void shouldReturnRenamedFile() throws URISyntaxException {
        List<DriveItem> items = this.addThreeFiles();
        DriveItem driveItem = items.get(0);
        DriveItem expectedItem = this.renamedItem(driveItem, "renF.test");
        DriveItem actualItem = oneDriveAPI.updateFile(expectedItem);
        Assert.assertEquals((Object)expectedItem.name, (Object)actualItem.name);
    }

    void assertListDriveItemEquals(List<DriveItem> expected, List<DriveItem> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Comparator<DriveItem> comparator = Comparator.comparing(file -> file.id);
        expected.sort(comparator);
        actual.sort(comparator);
        boolean isEquals = true;
        for (int i = 0; i < expected.size(); ++i) {
            DriveItem expectedItem = expected.get(i);
            DriveItem actualItem = actual.get(i);
            if (expectedItem.name.equals(actualItem.name) && expectedItem.id.equals(actualItem.id) && Objects.equals(expectedItem.size, actualItem.size)) continue;
            isEquals = false;
            break;
        }
        Assert.assertTrue((boolean)isEquals);
    }
}

