/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.EducationSchool;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.EducationSchoolCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.EducationSchoolCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.EducationSchoolCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.EducationSchoolRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IEducationSchoolCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IEducationSchoolCollectionRequest;

public class EducationSchoolCollectionRequest
extends BaseCollectionRequest<EducationSchoolCollectionResponse, IEducationSchoolCollectionPage>
implements IEducationSchoolCollectionRequest {
    public EducationSchoolCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSchoolCollectionResponse.class, IEducationSchoolCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEducationSchoolCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EducationSchoolCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationSchoolCollectionPage get() throws ClientException {
        EducationSchoolCollectionResponse response = (EducationSchoolCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(EducationSchool newEducationSchool, ICallback<EducationSchool> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EducationSchoolRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationSchool, callback);
    }

    @Override
    public EducationSchool post(EducationSchool newEducationSchool) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EducationSchoolRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationSchool);
    }

    @Override
    public IEducationSchoolCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IEducationSchoolCollectionPage buildFromResponse(EducationSchoolCollectionResponse response) {
        EducationSchoolCollectionRequestBuilder builder = response.nextLink != null ? new EducationSchoolCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationSchoolCollectionPage page = new EducationSchoolCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

