/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.MobileApp;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IMobileAppCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IMobileAppCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MobileAppCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MobileAppCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MobileAppCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MobileAppRequestBuilder;

public class MobileAppCollectionRequest
extends BaseCollectionRequest<MobileAppCollectionResponse, IMobileAppCollectionPage>
implements IMobileAppCollectionRequest {
    public MobileAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCollectionResponse.class, IMobileAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MobileAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppCollectionPage get() throws ClientException {
        MobileAppCollectionResponse response = (MobileAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileApp newMobileApp, ICallback<MobileApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileApp, callback);
    }

    @Override
    public MobileApp post(MobileApp newMobileApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileApp);
    }

    @Override
    public IMobileAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IMobileAppCollectionPage buildFromResponse(MobileAppCollectionResponse response) {
        MobileAppCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppCollectionPage page = new MobileAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

