/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ContentType;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ContentTypeCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ContentTypeCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ContentTypeCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ContentTypeRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IContentTypeCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IContentTypeCollectionRequest;

public class ContentTypeCollectionRequest
extends BaseCollectionRequest<ContentTypeCollectionResponse, IContentTypeCollectionPage>
implements IContentTypeCollectionRequest {
    public ContentTypeCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContentTypeCollectionResponse.class, IContentTypeCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IContentTypeCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ContentTypeCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContentTypeCollectionPage get() throws ClientException {
        ContentTypeCollectionResponse response = (ContentTypeCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ContentType newContentType, ICallback<ContentType> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ContentTypeRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContentType, callback);
    }

    @Override
    public ContentType post(ContentType newContentType) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ContentTypeRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContentType);
    }

    @Override
    public IContentTypeCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IContentTypeCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IContentTypeCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IContentTypeCollectionPage buildFromResponse(ContentTypeCollectionResponse response) {
        ContentTypeCollectionRequestBuilder builder = response.nextLink != null ? new ContentTypeCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContentTypeCollectionPage page = new ContentTypeCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

